/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth;

import com.google.common.base.Predicate;
import com.ki11erwolf.resynth.ResynthConfig;
import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ResynthWorldGen {
    private static boolean isInitialized = false;
    private final int weight;

    ResynthWorldGen() {
        this(0);
    }

    ResynthWorldGen(int weight) {
        this.weight = weight;
    }

    protected void init() {
        if (isInitialized) {
            ResynthMod.getLogger().warn("Attempt to initialize world generation twice. Skipping...");
            return;
        }
        for (WorldGenerators generator : WorldGenerators.values()) {
            generator.initMinable();
            GameRegistry.registerWorldGenerator((IWorldGenerator)generator, (int)this.weight);
        }
        isInitialized = true;
    }

    private static void internalGenerate(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int spawnTries, int minHeight, int maxHeight) {
        if (minHeight < 0) {
            minHeight = 0;
        }
        if (maxHeight > 255) {
            maxHeight = 255;
        }
        if (maxHeight < minHeight) {
            int i = minHeight;
            minHeight = maxHeight;
            maxHeight = i;
        } else if (maxHeight == minHeight) {
            if (maxHeight < 255) {
                ++maxHeight;
            } else {
                --minHeight;
            }
        }
        BlockPos chunkPos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < spawnTries; ++i) {
            generator.func_180709_b(world, random, chunkPos.func_177982_a(random.nextInt(16), minHeight + random.nextInt(heightDiff), random.nextInt(16)));
        }
    }

    protected static enum WorldGenerators implements IWorldGenerator
    {
        MINERAL_STONE_MINABLE(ResynthConfig.ORE_GENERATION.generate, Blocks.field_150348_b, ResynthBlocks.BLOCK_MINERAL_ORE.func_176223_P(), DimensionType.OVERWORLD, ResynthConfig.ORE_GENERATION.blockCount, ResynthConfig.ORE_GENERATION.perChunk, ResynthConfig.ORE_GENERATION.minHeight, ResynthConfig.ORE_GENERATION.maxHeight),
        MYSTICAL_SEED_POD_MINABLE(ResynthConfig.MYSTICAL_SEED_POD.generate, (Block)Blocks.field_150329_H, ResynthBlocks.BLOCK_SEED_POD.func_176223_P(), DimensionType.OVERWORLD, ResynthConfig.MYSTICAL_SEED_POD.blockCount, ResynthConfig.MYSTICAL_SEED_POD.perChunk, ResynthConfig.MYSTICAL_SEED_POD.minHeight, ResynthConfig.MYSTICAL_SEED_POD.maxHeight);

        private final boolean generate;
        private final Block target;
        private final IBlockState replacement;
        private final int blocksPerCluster;
        private final DimensionType dimension;
        private final int clustersPerChunk;
        private final int minHeight;
        private final int maxHeight;
        private WorldGenMinable worldGenInstance;

        private WorldGenerators(boolean generate, Block target, IBlockState replacement, DimensionType world, int blocksPerCluster, int clustersPerChunk, int minHeight, int maxHeight) {
            this.generate = generate;
            this.target = target;
            this.replacement = replacement;
            this.blocksPerCluster = blocksPerCluster;
            this.dimension = world;
            this.clustersPerChunk = clustersPerChunk;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }

        private void initMinable() {
            this.worldGenInstance = new WorldGenMinable(this.replacement, this.blocksPerCluster, (Predicate)BlockMatcher.func_177642_a((Block)this.target));
        }

        public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
            if (!this.generate) {
                return;
            }
            switch (world.field_73011_w.func_186058_p()) {
                case NETHER: {
                    if (this.dimension == DimensionType.NETHER) {
                        ResynthWorldGen.internalGenerate((WorldGenerator)this.worldGenInstance, world, random, chunkX, chunkZ, this.clustersPerChunk, this.minHeight, this.maxHeight);
                    }
                }
                case OVERWORLD: {
                    if (this.dimension != DimensionType.OVERWORLD) break;
                    ResynthWorldGen.internalGenerate((WorldGenerator)this.worldGenInstance, world, random, chunkX, chunkZ, this.clustersPerChunk, this.minHeight, this.maxHeight);
                    break;
                }
                case THE_END: {
                    if (this.dimension != DimensionType.THE_END) break;
                    ResynthWorldGen.internalGenerate((WorldGenerator)this.worldGenInstance, world, random, chunkX, chunkZ, this.clustersPerChunk, this.minHeight, this.maxHeight);
                }
            }
        }
    }
}

