/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.block;

import com.ki11erwolf.resynth.ResynthConfig;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.block.tileEntity.ResynthTileEntity;
import com.ki11erwolf.resynth.block.tileEntity.TileEntityMineralSoil;
import com.ki11erwolf.resynth.igtooltip.HwylaDataProvider;
import com.ki11erwolf.resynth.igtooltip.TOPDataProvider;
import com.ki11erwolf.resynth.item.ResynthItems;
import com.ki11erwolf.resynth.util.BlockUtil;
import com.ki11erwolf.resynth.util.MinecraftUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMineralSoil
extends ResynthTileEntity<TileEntityMineralSoil>
implements HwylaDataProvider,
TOPDataProvider {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"percent", (int)0, (int)4);
    protected static final AxisAlignedBB MINERAL_SOIL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
    private static final ResynthConfig.MineralSoil MINERAL_SOIL_CONFIG = ResynthConfig.MINERAL_SOIL;

    protected BlockMineralSoil() {
        super(Material.field_151577_b, SoundType.field_185849_b, "mineralSoil");
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.func_149713_g(255);
        BlockUtil.setHarvestLevel(this, BlockUtil.HarvestTools.SHOVEL, 0);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityMineralSoil te = (TileEntityMineralSoil)((Object)this.getTileEntity((IBlockAccess)worldIn, pos));
        int drops = (int)((te.getMineralPercentage() - 1.0f) / BlockMineralSoil.MINERAL_SOIL_CONFIG.mineralValue);
        EntityItem items = new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((Item)ResynthItems.ITEM_MINERAL_ROCK, drops));
        worldIn.func_72838_d((Entity)items);
        EntityItem mineralCrystal = new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((Item)ResynthItems.ITEM_MINERAL_CRYSTAL, 1));
        worldIn.func_72838_d((Entity)mineralCrystal);
    }

    public boolean func_180639_a(final World worldIn, final BlockPos pos, final IBlockState state, final EntityPlayer playerIn, final EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (((TileEntityMineralSoil)((Object)this.getTileEntity((IBlockAccess)worldIn, pos))).getMineralPercentage() >= 50.0f) {
            return false;
        }
        if (playerIn.func_184614_ca().func_77973_b().getClass().equals(((Object)((Object)ResynthItems.ITEM_MINERAL_ROCK)).getClass())) {
            new MinecraftUtil.SideSensitiveCode(worldIn){

                @Override
                public void onServer() {
                    ItemStack offer = playerIn.func_184614_ca();
                    TileEntityMineralSoil entity = (TileEntityMineralSoil)((Object)BlockMineralSoil.this.getTileEntity((IBlockAccess)worldIn, pos));
                    if (hand.equals((Object)EnumHand.MAIN_HAND)) {
                        if (!playerIn.func_184812_l_()) {
                            offer.func_190918_g(1);
                        }
                        entity.increaseMineralPercentage(MINERAL_SOIL_CONFIG.mineralValue);
                    }
                    float percentage = entity.getMineralPercentage();
                    BlockMineralSoil.this.updateState(worldIn, pos, state);
                    ((TileEntityMineralSoil)worldIn.func_175625_s(pos)).setMineralPercentage(percentage);
                    String perc = String.valueOf(entity.getMineralPercentage());
                    if (MINERAL_SOIL_CONFIG.enableChatMessage) {
                        playerIn.func_145747_a((ITextComponent)new TextComponentString("Soil mineral content: " + perc.substring(0, perc.length() > 4 ? 4 : perc.length()) + "%"));
                    }
                }
            }.execute();
            return true;
        }
        if (playerIn.func_184614_ca().func_77973_b().getClass().equals(((Object)((Object)ResynthItems.ITEM_DENSE_MINERAL_ROCK)).getClass())) {
            new MinecraftUtil.SideSensitiveCode(worldIn){

                @Override
                public void onServer() {
                    ItemStack offer = playerIn.func_184614_ca();
                    TileEntityMineralSoil entity = (TileEntityMineralSoil)((Object)BlockMineralSoil.this.getTileEntity((IBlockAccess)worldIn, pos));
                    if (hand.equals((Object)EnumHand.MAIN_HAND)) {
                        if (!playerIn.func_184812_l_()) {
                            offer.func_190918_g(1);
                        }
                        entity.increaseMineralPercentage(MINERAL_SOIL_CONFIG.mineralValue * 9.0f);
                    }
                    float percentage = entity.getMineralPercentage();
                    BlockMineralSoil.this.updateState(worldIn, pos, state);
                    ((TileEntityMineralSoil)worldIn.func_175625_s(pos)).setMineralPercentage(percentage);
                    String perc = String.valueOf(entity.getMineralPercentage());
                    if (MINERAL_SOIL_CONFIG.enableChatMessage) {
                        playerIn.func_145747_a((ITextComponent)new TextComponentString("Soil mineral content: " + perc.substring(0, perc.length() > 4 ? 4 : perc.length()) + "%"));
                    }
                }
            }.execute();
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
                Block block = iblockstate.func_177230_c();
                return !iblockstate.func_185914_p() && block != this && block != Blocks.field_185774_da;
            }
        }
        return super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150346_d);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return MINERAL_SOIL_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public Class<TileEntityMineralSoil> getTileEntityClass() {
        return TileEntityMineralSoil.class;
    }

    @Override
    public TileEntityMineralSoil createTileEntity(World world, IBlockState state) {
        return new TileEntityMineralSoil();
    }

    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Made by tilling (Right Clicking) dirt/grass with a Mineral Hoe.");
        tooltip.add("Right click with mineral rocks or dense mineral rock to increase plant growth.");
    }

    private void updateState(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityMineralSoil entity = (TileEntityMineralSoil)worldIn.func_175625_s(pos);
        float percentage = entity.getMineralPercentage();
        worldIn.func_175656_a(pos, BlockMineralSoil.getStateFromTileEntity(worldIn, pos));
    }

    private static IBlockState getStateFromTileEntity(World worldIn, BlockPos pos) {
        float percentage = ((TileEntityMineralSoil)worldIn.func_175625_s(pos)).getMineralPercentage();
        if ((double)percentage > 49.9) {
            return worldIn.func_180495_p(pos).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4));
        }
        if ((double)percentage > 39.9) {
            return worldIn.func_180495_p(pos).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(3));
        }
        if ((double)percentage > 29.9) {
            return worldIn.func_180495_p(pos).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(2));
        }
        if ((double)percentage > 19.9) {
            return worldIn.func_180495_p(pos).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(1));
        }
        return worldIn.func_180495_p(pos).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0));
    }

    @Override
    public void onHwylaBodyRequest(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        if (!(te instanceof TileEntityMineralSoil)) {
            return;
        }
        currentTip.add(TextFormatting.GREEN + "Mineral Content: " + accessor.getNBTData().func_74760_g("mineral-content") + "%");
        currentTip.add(TextFormatting.DARK_PURPLE + "Mineral Stage: " + BlockMineralSoil.percentToStage(accessor.getNBTData().func_74760_g("mineral-content")));
    }

    @Override
    public void onHwylaNBTDataRequest(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (!(te instanceof TileEntityMineralSoil)) {
            return;
        }
        tag.func_74776_a("mineral-content", ((TileEntityMineralSoil)te).getMineralPercentage());
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (!(te instanceof TileEntityMineralSoil)) {
            return;
        }
        TileEntityMineralSoil dataTileEntity = (TileEntityMineralSoil)te;
        probeInfo.horizontal().text(TextFormatting.GOLD + "Mineral Content: ");
        probeInfo.horizontal().item(new ItemStack((Block)ResynthBlocks.BLOCK_MINERAL_SOIL)).text(TextFormatting.GOLD + "Stage: " + TextFormatting.AQUA + BlockMineralSoil.percentToStage(dataTileEntity.getMineralPercentage()));
        probeInfo.horizontal().text(TextFormatting.GOLD + "Percentage:");
        probeInfo.horizontal().item(new ItemStack((Item)ResynthItems.ITEM_MINERAL_ROCK)).progress(Math.round(dataTileEntity.getMineralPercentage()) % 100, 100, probeInfo.defaultProgressStyle().suffix("%"));
    }

    private static String percentToStage(float percent) {
        if ((double)percent > 49.9) {
            return "5 of 5";
        }
        if ((double)percent > 39.9) {
            return "4 of 5";
        }
        if ((double)percent > 29.9) {
            return "3 of 5";
        }
        if ((double)percent > 19.9) {
            return "2 of 5";
        }
        return "1 of 5";
    }
}

