/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.igtooltip;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.igtooltip.HwylaDataProvider;
import com.ki11erwolf.resynth.igtooltip.ResynthIGTooltips;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.logging.log4j.Logger;

public class HwylaCompatibility
implements IWailaDataProvider {
    public static final HwylaCompatibility INSTANCE = new HwylaCompatibility();
    protected static final HwylaDataProvider BLANK_PROVIDER = (itemStack, tooltip, accessor, config) -> {};
    public static final Logger LOG = ResynthMod.getLogger();
    private static boolean registered;
    private static boolean loaded;

    private HwylaCompatibility() {
    }

    static void register() {
        if (registered) {
            return;
        }
        registered = true;
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"com.ki11erwolf.resynth.igtooltip.HwylaCompatibility.onHwylaLoad");
    }

    public static void onHwylaLoad(IWailaRegistrar registrar) {
        try {
            LOG.info("Hwyla register callback! Initializing...");
            for (Class tooltipProvider : ResynthIGTooltips.TOOLTIP_CLASSES) {
                registrar.registerHeadProvider((IWailaDataProvider)INSTANCE, tooltipProvider);
                registrar.registerBodyProvider((IWailaDataProvider)INSTANCE, tooltipProvider);
                registrar.registerTailProvider((IWailaDataProvider)INSTANCE, tooltipProvider);
            }
            for (Class nbtProvider : ResynthIGTooltips.TOOLTIP_TILE_ENTITY_CLASSES) {
                registrar.registerNBTProvider((IWailaDataProvider)INSTANCE, nbtProvider);
            }
            LOG.info("Hwyla register callback initialized without fatal errors!");
            loaded = true;
        }
        catch (Exception e) {
            LOG.error("Hwyla register callback ERRORED!", (Throwable)e);
            loaded = false;
            throw e;
        }
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        HwylaCompatibility.getProvider(world.func_180495_p(pos).func_177230_c()).onHwylaNBTDataRequest(player, te, tag, world, pos);
        return tag;
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return HwylaCompatibility.getProvider(accessor.getBlock()).onHwylaItemStackRequest(accessor, config);
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        HwylaCompatibility.getProvider(accessor.getBlock()).onHwylaHeadRequest(itemStack, tooltip, accessor, config);
        return tooltip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        HwylaCompatibility.getProvider(accessor.getBlock()).onHwylaBodyRequest(itemStack, tooltip, accessor, config);
        return tooltip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        HwylaCompatibility.getProvider(accessor.getBlock()).onHwylaTailRequest(itemStack, tooltip, accessor, config);
        return tooltip;
    }

    private static HwylaDataProvider getProvider(Object object) {
        if (object instanceof HwylaDataProvider) {
            return (HwylaDataProvider)object;
        }
        return BLANK_PROVIDER;
    }
}

