/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.item;

import com.ki11erwolf.resynth.ResynthConfig;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.item.ResynthItem;
import com.ki11erwolf.resynth.item.ResynthItems;
import com.ki11erwolf.resynth.util.MinecraftUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemMineralHoe
extends ResynthItem {
    private static final String NBT_TAG_CHARGES = "charges";
    private static final int INVENTORY_SLOT_TRIES = 80;

    ItemMineralHoe() {
        super("mineralHoe");
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(final EntityPlayer player, final World world, final BlockPos blockPos, EnumHand hand, EnumFacing blockDirection, float x, float y, float z) {
        if (!ResynthConfig.MINERAL_HOE.canUse) {
            return EnumActionResult.FAIL;
        }
        Block type = world.func_180495_p(blockPos).func_177230_c();
        final ItemStack stack = player.func_184586_b(hand);
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            nbt.func_74768_a(NBT_TAG_CHARGES, 0);
            stack.func_77982_d(nbt);
        }
        if (player.func_70093_af()) {
            new MinecraftUtil.SideSensitiveCode(world){

                @Override
                public void onServer() {
                    block8: {
                        if (player.func_70093_af()) {
                            if (stack.func_77978_p().func_74762_e(ItemMineralHoe.NBT_TAG_CHARGES) >= ResynthConfig.MINERAL_HOE.maxCharges) {
                                world.func_184133_a(null, blockPos, SoundEvents.field_187723_ct, SoundCategory.NEUTRAL, 0.7f, 1.0f);
                                return;
                            }
                            if (player.func_184812_l_()) {
                                stack.func_77978_p().func_74768_a(ItemMineralHoe.NBT_TAG_CHARGES, stack.func_77978_p().func_74762_e(ItemMineralHoe.NBT_TAG_CHARGES) + 1);
                                world.func_184133_a(null, blockPos, SoundEvents.field_187604_bf, SoundCategory.NEUTRAL, 0.7f, 1.0f);
                                return;
                            }
                            int pos = 0;
                            try {
                                while (true) {
                                    if (player.field_71071_by.func_70301_a(pos).func_77973_b() == ResynthItems.ITEM_MINERAL_CRYSTAL) {
                                        player.field_71071_by.func_70301_a(pos).func_190920_e(player.field_71071_by.func_70301_a(pos).func_190916_E() - 1);
                                        stack.func_77978_p().func_74768_a(ItemMineralHoe.NBT_TAG_CHARGES, stack.func_77978_p().func_74762_e(ItemMineralHoe.NBT_TAG_CHARGES) + 1);
                                        world.func_184133_a(null, blockPos, SoundEvents.field_187604_bf, SoundCategory.NEUTRAL, 0.7f, 1.0f);
                                        break block8;
                                    }
                                    if (pos >= 80) {
                                        world.func_184133_a(null, blockPos, SoundEvents.field_187723_ct, SoundCategory.NEUTRAL, 0.7f, 1.0f);
                                        break block8;
                                    }
                                    ++pos;
                                }
                            }
                            catch (Exception e) {}
                            {
                            }
                        }
                    }
                }
            }.execute();
            return EnumActionResult.FAIL;
        }
        if (!player.func_184812_l_() && nbt.func_74762_e(NBT_TAG_CHARGES) <= 0) {
            world.func_184133_a(player, blockPos, SoundEvents.field_187723_ct, SoundCategory.NEUTRAL, 0.7f, 1.0f);
            return EnumActionResult.FAIL;
        }
        if (type == Blocks.field_150346_d || type == Blocks.field_150349_c) {
            world.func_184133_a(null, blockPos, SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 0.4f, 1.2f / (world.field_73012_v.nextFloat() * 0.2f + 0.9f));
            ItemMineralHoe.spawnBlockChangeParticles(world, blockPos);
            world.func_175656_a(blockPos, ResynthBlocks.BLOCK_MINERAL_SOIL.func_176223_P());
            if (!player.func_184812_l_()) {
                nbt.func_74768_a(NBT_TAG_CHARGES, nbt.func_74762_e(NBT_TAG_CHARGES) - 1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
            nbt.func_74768_a(NBT_TAG_CHARGES, ResynthConfig.MINERAL_HOE.initialCharges);
        }
        tooltip.add(TextFormatting.GOLD + "Charges: " + nbt.func_74762_e(NBT_TAG_CHARGES));
        tooltip.add(TextFormatting.GRAY + "Sneak + Right Click on a block with Mineral Crystals in inventory to charge.");
    }

    private static void spawnBlockChangeParticles(World worldIn, BlockPos pos) {
        int amount = 100;
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_185904_a() != Material.field_151579_a) {
            for (int i = 0; i < amount; ++i) {
                double d0 = field_77697_d.nextGaussian() * 0.02;
                double d1 = field_77697_d.nextGaussian() * 0.02;
                double d2 = field_77697_d.nextGaussian() * 0.02;
                worldIn.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, (double)((float)pos.func_177958_n() + field_77697_d.nextFloat()), (double)pos.func_177956_o() + (double)field_77697_d.nextFloat() * iblockstate.func_185900_c((IBlockAccess)worldIn, (BlockPos)pos).field_72337_e, (double)((float)pos.func_177952_p() + field_77697_d.nextFloat()), d0, d1, d2, new int[0]);
            }
        } else {
            for (int i1 = 0; i1 < amount; ++i1) {
                double d0 = field_77697_d.nextGaussian() * 0.02;
                double d1 = field_77697_d.nextGaussian() * 0.02;
                double d2 = field_77697_d.nextGaussian() * 0.02;
                worldIn.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, (double)((float)pos.func_177958_n() + field_77697_d.nextFloat()), (double)pos.func_177956_o() + (double)field_77697_d.nextFloat() * 1.0, (double)((float)pos.func_177952_p() + field_77697_d.nextFloat()), d0, d1, d2, new int[0]);
            }
        }
    }
}

