/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.plant.ModPlantSetBase;
import com.ki11erwolf.resynth.plant.PlantSetCrystalline;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Logger;

public abstract class ModPlantSetCrystalline
extends ModPlantSetBase<PlantSetCrystalline> {
    private static final Logger LOG = ResynthMod.getLogger();
    private Item result;

    public ModPlantSetCrystalline(String name, final String modid, String oreBlockName, final String resourceName, final int metaData) {
        if (!Loader.isModLoaded((String)modid)) {
            LOG.info("Mod: " + modid + " not loaded. Skipping plant: " + name + "...");
            return;
        }
        LOG.info("Loading mod plant: " + name + " | mod: " + modid);
        Block modOreBlock = ModPlantSetCrystalline.getModBlock(modid, oreBlockName);
        if (modOreBlock == null) {
            LOG.warn("Could not find mod ore block: " + modid + ":" + oreBlockName + ". Skipping...");
            return;
        }
        this.backingPlantSet = new PlantSetCrystalline(name, modOreBlock){

            @Override
            public ItemStack getResult() {
                if (ModPlantSetCrystalline.this.result == null) {
                    ModPlantSetCrystalline.this.result = ModPlantSetBase.getModItem(modid, resourceName);
                    if (ModPlantSetCrystalline.this.result == null) {
                        LOG.error("Failed to get mod resource item: " + modid + ":" + resourceName);
                        ModPlantSetCrystalline.this.result = ModPlantSetBase.getModItem("minecraft", "dirt");
                    }
                }
                return new ItemStack(ModPlantSetCrystalline.this.result, ModPlantSetCrystalline.this.getResultCount(), metaData);
            }

            @Override
            protected boolean doesOreDropSeeds() {
                return ModPlantSetCrystalline.this.doesModOreDropSeeds();
            }

            @Override
            protected float getOreSeedDropChance() {
                return ModPlantSetCrystalline.this.getModOreSeedDropChance();
            }

            @Override
            protected float getPlantGrowthChance() {
                return ModPlantSetCrystalline.this.getModPlantGrowthChance();
            }

            @Override
            protected boolean canBonemealPlant() {
                return ModPlantSetCrystalline.this.canBonemealModPlant();
            }

            @Override
            protected float getProduceSeedDropChance() {
                return ModPlantSetCrystalline.this.getModProduceSeedDropChance();
            }

            @Override
            protected boolean doesProduceDropSeeds() {
                return ModPlantSetCrystalline.this.doesModProduceDropSeeds();
            }
        };
    }

    public ModPlantSetCrystalline register() {
        return (ModPlantSetCrystalline)super.register();
    }

    protected abstract int getResultCount();

    protected abstract boolean doesModOreDropSeeds();

    protected abstract float getModOreSeedDropChance();

    protected abstract float getModPlantGrowthChance();

    protected abstract boolean canBonemealModPlant();

    protected abstract float getModProduceSeedDropChance();

    protected abstract boolean doesModProduceDropSeeds();
}

