/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.plant.ModPlantSetBase;
import com.ki11erwolf.resynth.plant.PlantSetMetallic;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Logger;

public abstract class ModPlantSetMetallic
extends ModPlantSetBase<PlantSetMetallic> {
    private static final Logger LOG = ResynthMod.getLogger();
    private Item result;

    public ModPlantSetMetallic(String name, String modid, String oreBlockName, int oreMetaData, final String resourceName, final int metaData) {
        if (!Loader.isModLoaded((String)modid)) {
            LOG.info("Mod: " + modid + " not loaded. Skipping plant: " + name + "...");
            return;
        }
        LOG.info("Loading mod plant: " + name + " | mod: " + modid);
        Block modOreBlock = ModPlantSetMetallic.getModBlock(modid, oreBlockName);
        if (modOreBlock == null) {
            LOG.warn("Could not find mod ore block: " + modid + ":" + oreBlockName + ". Skipping...");
            return;
        }
        this.backingPlantSet = new PlantSetMetallic(name, new ItemStack(modOreBlock, 1, oreMetaData)){

            @Override
            public ItemStack getResult() {
                if (ModPlantSetMetallic.this.result == null) {
                    ModPlantSetMetallic.this.result = ModPlantSetBase.getModItem(this.modid, resourceName);
                    if (ModPlantSetMetallic.this.result == null) {
                        LOG.error("Failed to get mod resource item: " + this.modid + ":" + resourceName);
                        ModPlantSetMetallic.this.result = ModPlantSetBase.getModItem("minecraft", "dirt");
                    }
                }
                return new ItemStack(ModPlantSetMetallic.this.result, ModPlantSetMetallic.this.getResultCount(), metaData);
            }

            @Override
            protected float getPlantGrowthChance() {
                return ModPlantSetMetallic.this.getModPlantGrowthChance();
            }

            @Override
            protected boolean canBonemealPlant() {
                return ModPlantSetMetallic.this.canBonemealModPlant();
            }

            @Override
            protected float getSourceOreSeedDropChance() {
                return ModPlantSetMetallic.this.getModOreSeedDropChance();
            }

            @Override
            protected float getProduceSeedDropChance() {
                return ModPlantSetMetallic.this.getModProduceSeedDropChance();
            }

            @Override
            protected boolean doesSourceOreDropSeeds() {
                return ModPlantSetMetallic.this.doesModOreDropSeeds();
            }

            @Override
            protected boolean doesPlantOreDropSeeds() {
                return ModPlantSetMetallic.this.doesModProduceDropSeeds();
            }
        };
        ((PlantSetMetallic)this.backingPlantSet).modid = modid;
        ((PlantSetMetallic)this.backingPlantSet).oreBlockName = oreBlockName;
        ((PlantSetMetallic)this.backingPlantSet).oreMetaData = oreMetaData;
    }

    public ModPlantSetMetallic register() {
        return (ModPlantSetMetallic)super.register();
    }

    protected abstract int getResultCount();

    protected abstract boolean doesModOreDropSeeds();

    protected abstract float getModOreSeedDropChance();

    protected abstract float getModPlantGrowthChance();

    protected abstract boolean canBonemealModPlant();

    protected abstract float getModProduceSeedDropChance();

    protected abstract boolean doesModProduceDropSeeds();
}

