/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant;

import com.ki11erwolf.resynth.ResynthConfig;
import com.ki11erwolf.resynth.plant.ResynthPlantSetRegistry;
import com.ki11erwolf.resynth.plant.block.BlockPlantBase;
import com.ki11erwolf.resynth.plant.block.BlockPlantBiochemical;
import com.ki11erwolf.resynth.plant.item.ItemPlantProduceBulb;
import com.ki11erwolf.resynth.plant.item.ItemPlantSeeds;
import com.ki11erwolf.resynth.util.MathUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public abstract class PlantSetBiochemical {
    private final BlockPlantBiochemical plant;
    private final ItemPlantProduceBulb produce;
    private final ItemPlantSeeds seeds;
    private final Class<? extends EntityLiving> entity;

    public PlantSetBiochemical(String name, Class<? extends EntityLiving> entity) {
        this.entity = entity;
        this.plant = new BlockPlantBiochemical(name){

            @Override
            protected Item getSeed() {
                return PlantSetBiochemical.this.seeds;
            }

            @Override
            protected Item getProduce() {
                return PlantSetBiochemical.this.produce;
            }

            @Override
            protected float _getGrowthChance() {
                return PlantSetBiochemical.this.getPlantGrowthChance();
            }

            @Override
            protected boolean canBonemeal() {
                return PlantSetBiochemical.this.canBonemealPlant();
            }
        };
        this.seeds = new ItemPlantSeeds((BlockPlantBase)this.plant, name, this);
        this.produce = new ItemPlantProduceBulb(name, this.seeds, this){

            @Override
            protected float getSeedSpawnChance() {
                return PlantSetBiochemical.this.getProduceSeedDropChance();
            }
        };
        this.register();
    }

    @SubscribeEvent
    public static void onMobDeath(LivingDeathEvent deathEvent) {
        Entity causer = deathEvent.getSource().func_76346_g();
        Entity victim = deathEvent.getEntity();
        if (causer == null || causer.getClass() != EntityPlayerMP.class || !ResynthConfig.PLANTS_GENERAL.mobDropSeeds) {
            return;
        }
        for (PlantSetBiochemical plant : ResynthPlantSetRegistry.getBiochemicalPlantSets()) {
            if (victim.getClass() != plant.entity || !plant.doesMobDropSeeds() || !MathUtil.chance(plant.getMobSeedDropChance())) continue;
            ItemPlantSeeds.addEffects(victim.field_70170_p, new BlockPos(victim.field_70165_t, victim.field_70163_u, victim.field_70161_v));
            victim.func_130014_f_().func_72838_d((Entity)new EntityItem(victim.func_130014_f_(), victim.field_70165_t, victim.field_70163_u, victim.field_70161_v, new ItemStack((Item)plant.getSeeds(), 1)));
        }
    }

    public BlockPlantBiochemical getPlant() {
        return this.plant;
    }

    public ItemPlantSeeds getSeeds() {
        return this.seeds;
    }

    public ItemPlantProduceBulb getProduce() {
        return this.produce;
    }

    private void register() {
        ResynthPlantSetRegistry.addPlantBlock(this.plant);
        ResynthPlantSetRegistry.addBulbProduce(this.produce);
        ResynthPlantSetRegistry.addSeeds(this.seeds);
        ResynthPlantSetRegistry.addPlantSet(this);
    }

    public String getTextualMobSeedDropChance() {
        return Math.round(this.getMobSeedDropChance()) + "%";
    }

    public String getTextualProduceSeedDropChance() {
        return Math.round(this.getProduceSeedDropChance()) + "%";
    }

    public String getTextualPlantGrowthChance() {
        return Math.round(this.getPlantGrowthChance()) + "%";
    }

    public String getTextualPodSeedDropChance() {
        if (!ResynthConfig.MYSTICAL_SEED_POD.dropSeeds) {
            return "Not Enabled";
        }
        return Math.round(this.getSeedPodDropPercentage()) + "%";
    }

    public abstract ItemStack getResult();

    protected abstract boolean doesMobDropSeeds();

    protected abstract float getMobSeedDropChance();

    protected abstract float getPlantGrowthChance();

    protected abstract boolean canBonemealPlant();

    protected abstract float getProduceSeedDropChance();

    protected abstract boolean doesProduceDropSeeds();

    public abstract float getSeedPodDropPercentage();
}

