/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant;

import com.ki11erwolf.resynth.ResynthConfig;
import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.plant.ResynthPlantSetRegistry;
import com.ki11erwolf.resynth.plant.ResynthPlantSets;
import com.ki11erwolf.resynth.plant.block.BlockPlantBase;
import com.ki11erwolf.resynth.plant.block.BlockPlantCrystalline;
import com.ki11erwolf.resynth.plant.item.ItemPlantProduceShard;
import com.ki11erwolf.resynth.plant.item.ItemPlantSeeds;
import com.ki11erwolf.resynth.util.MathUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public abstract class PlantSetCrystalline {
    private final BlockPlantCrystalline plant;
    private final ItemPlantProduceShard produce;
    private final ItemPlantSeeds seeds;
    private final Block sourceOre;

    public PlantSetCrystalline(String name, Block sourceOre) {
        this.sourceOre = sourceOre;
        this.plant = new BlockPlantCrystalline(name){

            @Override
            protected Item getSeed() {
                return PlantSetCrystalline.this.seeds;
            }

            @Override
            protected Item getProduce() {
                return PlantSetCrystalline.this.produce;
            }

            @Override
            protected float _getGrowthChance() {
                return PlantSetCrystalline.this.getPlantGrowthChance();
            }

            @Override
            protected boolean canBonemeal() {
                return PlantSetCrystalline.this.canBonemealPlant();
            }
        };
        this.produce = new ItemPlantProduceShard(name, this);
        this.seeds = new ItemPlantSeeds((BlockPlantBase)this.plant, name, this);
    }

    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        if (!ResynthConfig.PLANTS_GENERAL.oreDropSeeds) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        if (event.getPlayer().func_184812_l_()) {
            return;
        }
        for (NBTBase tag : event.getPlayer().func_184614_ca().func_77986_q()) {
            if (((NBTTagCompound)tag).func_74765_d("id") != 33) continue;
            return;
        }
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        World world = event.getWorld();
        double x = event.getPos().func_177958_n();
        double y = event.getPos().func_177956_o();
        double z = event.getPos().func_177952_p();
        for (PlantSetCrystalline plant : ResynthPlantSetRegistry.getCrystallinePlantSets()) {
            if (!plant.doesOreDropSeeds()) {
                return;
            }
            if (block != plant.sourceOre) continue;
            if (!event.getPlayer().func_184614_ca().func_77973_b().func_150897_b(event.getState())) {
                ResynthMod.getLogger().warn("Ore broken with item that cannot harvest: " + event.getPlayer().func_184614_ca().func_77973_b().getClass().getCanonicalName());
            }
            if (!MathUtil.chance(plant.getOreSeedDropChance())) continue;
            ItemPlantSeeds.addEffects(world, event.getPos());
            world.func_72838_d((Entity)new EntityItem(world, x, y, z, new ItemStack((Item)plant.seeds, 1)));
            event.setCanceled(true);
            world.func_175698_g(event.getPos());
        }
    }

    @SubscribeEvent
    public static void onItemExpire(ItemExpireEvent event) {
        Item i = event.getEntityItem().func_92059_d().func_77973_b();
        World world = event.getEntityItem().field_70170_p;
        BlockPos pos = event.getEntityItem().func_180425_c();
        int count = event.getEntityItem().func_92059_d().func_190916_E();
        Block b = world.func_180495_p(pos).func_177230_c();
        for (PlantSetCrystalline p : ResynthPlantSets.getCrystallinePlantSets()) {
            if (i == p.getSeeds()) {
                event.setCanceled(true);
                return;
            }
            if (!p.doesProduceDropSeeds() || !ResynthConfig.PLANTS_GENERAL.produceDropSeeds || i != p.getProduce() || b != Blocks.field_150355_j) continue;
            for (int j = 0; j < count; ++j) {
                if (!MathUtil.chance(p.getProduceSeedDropChance())) continue;
                ItemPlantSeeds.addEffects(world, pos);
                event.getEntityItem().field_70170_p.func_72838_d((Entity)new EntityItem(event.getEntityItem().field_70170_p, event.getEntityItem().field_70165_t, event.getEntityItem().field_70163_u, event.getEntityItem().field_70161_v, new ItemStack((Item)p.getSeeds(), 1)));
            }
            return;
        }
    }

    public BlockPlantCrystalline getPlant() {
        return this.plant;
    }

    public ItemPlantSeeds getSeeds() {
        return this.seeds;
    }

    public ItemPlantProduceShard getProduce() {
        return this.produce;
    }

    protected PlantSetCrystalline register() {
        ResynthPlantSetRegistry.addPlantBlock(this.plant);
        ResynthPlantSetRegistry.addShardProduce(this.produce);
        ResynthPlantSetRegistry.addSeeds(this.seeds);
        ResynthPlantSetRegistry.addPlantSet(this);
        return this;
    }

    public String getTextualOreSeedDropChance() {
        return Math.round(this.getOreSeedDropChance()) + "%";
    }

    public String getTextualProduceSeedDropChance() {
        return Math.round(this.getProduceSeedDropChance()) + "%";
    }

    public String getTextualPlantGrowthChance() {
        return Math.round(this.getPlantGrowthChance()) + "%";
    }

    public abstract ItemStack getResult();

    protected abstract boolean doesOreDropSeeds();

    protected abstract float getOreSeedDropChance();

    protected abstract float getPlantGrowthChance();

    protected abstract boolean canBonemealPlant();

    protected abstract float getProduceSeedDropChance();

    protected abstract boolean doesProduceDropSeeds();
}

