/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant;

import com.ki11erwolf.resynth.ResynthConfig;
import com.ki11erwolf.resynth.plant.ModPlantSetBase;
import com.ki11erwolf.resynth.plant.ResynthPlantSetRegistry;
import com.ki11erwolf.resynth.plant.block.BlockOrganicPlantOre;
import com.ki11erwolf.resynth.plant.block.BlockPlantBase;
import com.ki11erwolf.resynth.plant.block.BlockPlantMetallic;
import com.ki11erwolf.resynth.plant.item.ItemPlantSeeds;
import com.ki11erwolf.resynth.util.MathUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public abstract class PlantSetMetallic {
    private final ItemStack sourceOre;
    private final BlockOrganicPlantOre plantOre;
    private final BlockPlantMetallic plant;
    private final ItemPlantSeeds seeds;
    protected String modid;
    protected String oreBlockName;
    protected int oreMetaData;

    public PlantSetMetallic(String name, ItemStack sourceOre) {
        this.sourceOre = sourceOre;
        this.plantOre = new BlockOrganicPlantOre(name, this);
        this.plant = new BlockPlantMetallic(this.plantOre, name){

            @Override
            protected Item getSeedItem() {
                return PlantSetMetallic.this.seeds;
            }

            @Override
            protected float _getGrowthChance() {
                return PlantSetMetallic.this.getPlantGrowthChance();
            }

            @Override
            protected boolean canBonemeal() {
                return PlantSetMetallic.this.canBonemealPlant();
            }
        };
        this.seeds = new ItemPlantSeeds((BlockPlantBase)this.plant, name, this);
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate detonateEvent) {
        List affectedBlocks = detonateEvent.getAffectedBlocks();
        for (BlockPos blockPos : affectedBlocks) {
            Block block = detonateEvent.getWorld().func_180495_p(blockPos).func_177230_c();
            IBlockState state = detonateEvent.getWorld().func_180495_p(blockPos);
            for (PlantSetMetallic plant : ResynthPlantSetRegistry.getMetallicPlantSets()) {
                if (plant.modid != null && plant.doesSourceOreDropSeeds() && ResynthConfig.PLANTS_GENERAL.oreDropSeeds) {
                    if (block == ModPlantSetBase.getModBlock(plant.modid, plant.oreBlockName) && block.func_176201_c(state) == plant.oreMetaData && MathUtil.chance(plant.getSourceOreSeedDropChance())) {
                        detonateEvent.getWorld().func_175698_g(blockPos);
                        ItemPlantSeeds.addEffects(detonateEvent.getWorld(), blockPos);
                        detonateEvent.getWorld().func_72838_d((Entity)new EntityItem(detonateEvent.getWorld(), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), new ItemStack((Item)plant.seeds, 1)));
                    }
                } else if (plant.doesSourceOreDropSeeds() && block == Block.func_149634_a((Item)plant.sourceOre.func_77973_b()) && ResynthConfig.PLANTS_GENERAL.oreDropSeeds) {
                    if (plant.sourceOre.func_77973_b() == Items.field_190931_a) continue;
                    if (MathUtil.chance(plant.getSourceOreSeedDropChance())) {
                        detonateEvent.getWorld().func_175698_g(blockPos);
                        ItemPlantSeeds.addEffects(detonateEvent.getWorld(), blockPos);
                        detonateEvent.getWorld().func_72838_d((Entity)new EntityItem(detonateEvent.getWorld(), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), new ItemStack((Item)plant.seeds, 1)));
                    }
                }
                if (!plant.doesPlantOreDropSeeds() || block != plant.plantOre || !ResynthConfig.PLANTS_GENERAL.organicOreDropSeeds || !MathUtil.chance(plant.getProduceSeedDropChance())) continue;
                detonateEvent.getWorld().func_175698_g(blockPos);
                ItemPlantSeeds.addEffects(detonateEvent.getWorld(), blockPos);
                detonateEvent.getWorld().func_72838_d((Entity)new EntityItem(detonateEvent.getWorld(), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), new ItemStack((Item)plant.seeds, 1)));
            }
        }
    }

    protected PlantSetMetallic register() {
        ResynthPlantSetRegistry.addOrganicOreBlock(this.plantOre);
        ResynthPlantSetRegistry.addPlantBlock(this.plant);
        ResynthPlantSetRegistry.addSeeds(this.seeds);
        ResynthPlantSetRegistry.addPlantSet(this);
        return this;
    }

    public String getTextualOreSeedDropChance() {
        return Math.round(this.getSourceOreSeedDropChance()) + "%";
    }

    public String getTextualProduceSeedDropChance() {
        return Math.round(this.getProduceSeedDropChance()) + "%";
    }

    public String getTextualPlantGrowthChance() {
        return Math.round(this.getPlantGrowthChance()) + "%";
    }

    public BlockOrganicPlantOre getPlantOre() {
        return this.plantOre;
    }

    public ItemPlantSeeds getSeeds() {
        return this.seeds;
    }

    public BlockPlantMetallic getPlant() {
        return this.plant;
    }

    public abstract ItemStack getResult();

    protected abstract float getPlantGrowthChance();

    protected abstract boolean canBonemealPlant();

    protected abstract float getSourceOreSeedDropChance();

    protected abstract float getProduceSeedDropChance();

    protected abstract boolean doesSourceOreDropSeeds();

    protected abstract boolean doesPlantOreDropSeeds();
}

