/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant;

import com.ki11erwolf.resynth.plant.PlantSetBiochemical;
import com.ki11erwolf.resynth.plant.PlantSetCrystalline;
import com.ki11erwolf.resynth.plant.PlantSetMetallic;
import com.ki11erwolf.resynth.plant.block.BlockOrganicPlantOre;
import com.ki11erwolf.resynth.plant.block.BlockPlantBase;
import com.ki11erwolf.resynth.plant.item.ItemPlantProduceBulb;
import com.ki11erwolf.resynth.plant.item.ItemPlantProduceShard;
import com.ki11erwolf.resynth.plant.item.ItemPlantSeeds;
import java.util.ArrayList;

final class ResynthPlantSetRegistry {
    private static final ArrayList<PlantSetMetallic> METALLIC_PLANT_SETS = new ArrayList();
    private static final ArrayList<PlantSetBiochemical> BIOCHEMICAL_PLANT_SETS = new ArrayList();
    private static final ArrayList<PlantSetCrystalline> CRYSTALLINE_PLANT_SETS = new ArrayList();
    private static final ArrayList<BlockPlantBase> PLANT_BLOCKS = new ArrayList();
    private static final ArrayList<ItemPlantSeeds> PLANT_SEEDS = new ArrayList();
    private static final ArrayList<BlockOrganicPlantOre> ORGANIC_ORE_BLOCKS = new ArrayList();
    private static final ArrayList<ItemPlantProduceShard> PLANT_SHARD_PRODUCE_ITEMS = new ArrayList();
    private static final ArrayList<ItemPlantProduceBulb> PLANT_BULB_PRODUCES_ITEMS = new ArrayList();

    private ResynthPlantSetRegistry() {
    }

    protected static void addPlantSet(PlantSetMetallic plantSet) {
        METALLIC_PLANT_SETS.add(plantSet);
    }

    protected static void addPlantSet(PlantSetCrystalline plantSet) {
        CRYSTALLINE_PLANT_SETS.add(plantSet);
    }

    protected static void addPlantSet(PlantSetBiochemical plantSet) {
        BIOCHEMICAL_PLANT_SETS.add(plantSet);
    }

    protected static void addPlantBlock(BlockPlantBase plant) {
        PLANT_BLOCKS.add(plant);
    }

    protected static void addSeeds(ItemPlantSeeds seeds) {
        PLANT_SEEDS.add(seeds);
    }

    protected static void addOrganicOreBlock(BlockOrganicPlantOre ore) {
        ORGANIC_ORE_BLOCKS.add(ore);
    }

    protected static void addShardProduce(ItemPlantProduceShard produce) {
        PLANT_SHARD_PRODUCE_ITEMS.add(produce);
    }

    protected static void addBulbProduce(ItemPlantProduceBulb produce) {
        PLANT_BULB_PRODUCES_ITEMS.add(produce);
    }

    protected static BlockPlantBase[] getPlantBlocks() {
        return PLANT_BLOCKS.toArray(new BlockPlantBase[0]);
    }

    protected static ItemPlantSeeds[] getSeedItems() {
        return PLANT_SEEDS.toArray(new ItemPlantSeeds[0]);
    }

    protected static BlockOrganicPlantOre[] getOrganicOreBlocks() {
        return ORGANIC_ORE_BLOCKS.toArray(new BlockOrganicPlantOre[0]);
    }

    protected static PlantSetMetallic[] getMetallicPlantSets() {
        return METALLIC_PLANT_SETS.toArray(new PlantSetMetallic[0]);
    }

    protected static PlantSetBiochemical[] getBiochemicalPlantSets() {
        return BIOCHEMICAL_PLANT_SETS.toArray(new PlantSetBiochemical[0]);
    }

    protected static PlantSetCrystalline[] getCrystallinePlantSets() {
        return CRYSTALLINE_PLANT_SETS.toArray(new PlantSetCrystalline[0]);
    }

    protected static ItemPlantProduceShard[] getShardProduceItems() {
        return PLANT_SHARD_PRODUCE_ITEMS.toArray(new ItemPlantProduceShard[0]);
    }

    protected static ItemPlantProduceBulb[] getBulbProduceItems() {
        return PLANT_BULB_PRODUCES_ITEMS.toArray(new ItemPlantProduceBulb[0]);
    }
}

