/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.block;

import com.ki11erwolf.resynth.ResynthConfig;
import com.ki11erwolf.resynth.block.ResynthBlock;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.block.tileEntity.TileEntityMineralSoil;
import com.ki11erwolf.resynth.util.MathUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockPlantBase
extends ResynthBlock
implements IGrowable,
IPlantable {
    protected static final String PLANT_PREFIX = "plant";
    protected static final AxisAlignedBB DEFAULT_AABB = new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.6f, (double)0.7f);

    protected BlockPlantBase(String name) {
        super(Material.field_151585_k, SoundType.field_185850_c, name, PLANT_PREFIX);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return ResynthConfig.PLANTS_GENERAL.canBonemeal && this.canBonemeal();
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DEFAULT_AABB;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        this.dropIfShould(worldIn, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (!ResynthConfig.PLANTS_GENERAL.enableSmokingPlants) {
            return;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        int amount = 3;
        if (!MathUtil.chance(2.0f)) {
            return;
        }
        if (iblockstate.func_185904_a() != Material.field_151579_a) {
            for (int i = 0; i < amount; ++i) {
                double d0 = rand.nextGaussian() * 0.02;
                double d1 = rand.nextGaussian() * 0.02;
                double d2 = rand.nextGaussian() * 0.02;
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)pos.func_177956_o() + (double)rand.nextFloat() * iblockstate.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72337_e, (double)((float)pos.func_177952_p() + rand.nextFloat()), d0, d1, d2, new int[0]);
            }
        } else {
            for (int i1 = 0; i1 < amount; ++i1) {
                double d0 = rand.nextGaussian() * 0.02;
                double d1 = rand.nextGaussian() * 0.02;
                double d2 = rand.nextGaussian() * 0.02;
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)pos.func_177956_o() + (double)rand.nextFloat() * 1.0, (double)((float)pos.func_177952_p() + rand.nextFloat()), d0, d1, d2, new int[0]);
            }
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this.getSoilBlock();
    }

    protected boolean canSustainPlant(IBlockState state) {
        return state.func_177230_c() == this.getSoilBlock();
    }

    protected Block getSoilBlock() {
        return ResynthBlocks.BLOCK_MINERAL_SOIL;
    }

    protected void dropIfShould(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    protected boolean canStay(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this.getSoilBlock();
    }

    protected boolean shouldGrow(World world, BlockPos pos) {
        float randomChance = MathUtil.getRandomIntegerInRange(0, 100);
        float chance = this.getSoilMineralContent(world, pos);
        if (!(chance > randomChance)) {
            return false;
        }
        return MathUtil.chance(this._getGrowthChance());
    }

    protected float getSoilMineralContent(World world, BlockPos pos) {
        if (world.func_175625_s(pos.func_177977_b()).func_145838_q() != ResynthBlocks.BLOCK_MINERAL_SOIL) {
            return 0.0f;
        }
        TileEntityMineralSoil tEntity = (TileEntityMineralSoil)world.func_175625_s(pos.func_177977_b());
        return tEntity.getMineralPercentage();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.dropIfShould(worldIn, pos, state);
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (worldIn.func_175671_l(pos.func_177984_a()) < 9) {
            return;
        }
        boolean grow = this.shouldGrow(worldIn, pos);
        if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)grow) && ResynthConfig.PLANTS_GENERAL.enableGrowth) {
            this.onGrowApproved(worldIn, pos, state, rand);
        }
    }

    static String getStageFromBlockMeta(int meta) {
        if (meta == 0) {
            return "1 of 8 (0%)";
        }
        if (meta == 1) {
            return "2 of 8 (14%)";
        }
        if (meta == 2) {
            return "3 of 8 (29%)";
        }
        if (meta == 3) {
            return "4 of 8 (43%)";
        }
        if (meta == 4) {
            return "5 of 8 (57%)";
        }
        if (meta == 5) {
            return "6 of 8 (71%)";
        }
        if (meta == 6) {
            return "7 of 8 (85%)";
        }
        if (meta == 7) {
            return "8 of 8 (100%)";
        }
        return "Unknown";
    }

    protected abstract void onGrowApproved(World var1, BlockPos var2, IBlockState var3, Random var4);

    protected abstract float _getGrowthChance();

    protected abstract boolean canBonemeal();
}

