/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.block;

import com.ki11erwolf.resynth.ResynthConfig;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.igtooltip.HwylaDataProvider;
import com.ki11erwolf.resynth.plant.block.BlockPlantBase;
import java.util.List;
import java.util.Random;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public abstract class BlockPlantBiochemical
extends BlockPlantBase
implements HwylaDataProvider {
    public static final PropertyInteger GROWTH_STAGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    protected static final AxisAlignedBB[] BIO_FLOWER_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.125, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.25, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.5, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.625, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.75, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.875, 0.625)};

    public BlockPlantBiochemical(String name) {
        super(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.getGrowthStageProperty(), (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149647_a(null);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149649_H();
    }

    public IBlockState withGrowthStage(int stage) {
        return this.func_176223_P().func_177226_a((IProperty)this.getGrowthStageProperty(), (Comparable)Integer.valueOf(stage));
    }

    public boolean isMaxGrowthStage(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getGrowthStageProperty()) >= this.getMaxGrowthStage();
    }

    public int getMaxGrowthStage() {
        return 7;
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return (worldIn.func_175699_k(pos) >= 8 || worldIn.func_175678_i(pos)) && soil.func_177230_c() == ResynthBlocks.BLOCK_MINERAL_SOIL;
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state) {
        int j;
        int i = this.getGrowthStage(state) + this.getBonemealGrowthStageIncrease(worldIn);
        if (i > (j = this.getMaxGrowthStage())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.withGrowthStage(i), 2);
    }

    protected boolean canSustainBush(IBlockState state) {
        return state.func_177230_c() == ResynthBlocks.BLOCK_MINERAL_SOIL;
    }

    protected PropertyInteger getGrowthStageProperty() {
        return GROWTH_STAGE;
    }

    protected int getGrowthStage(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getGrowthStageProperty());
    }

    protected int getBonemealGrowthStageIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
    }

    @Override
    public void onGrowApproved(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i;
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && (i = this.getGrowthStage(state)) < this.getMaxGrowthStage() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
            worldIn.func_180501_a(pos, this.withGrowthStage(i + 1), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.getGrowthStage(state) >= this.getMaxGrowthStage() && !worldIn.field_72995_K) {
            worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, 0.4f / (new Random().nextFloat() * 0.4f + 0.8f));
            worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), new ItemStack(this.getProduce(), 1)));
            worldIn.func_180501_a(pos, this.withGrowthStage(3), 2);
            return true;
        }
        return false;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, 0);
        int age = this.getGrowthStage(state);
        if (age >= this.getMaxGrowthStage()) {
            drops.add((Object)new ItemStack(this.getSeed(), 1, 0));
        }
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BIO_FLOWER_AABB[(Integer)state.func_177229_b((IProperty)this.getGrowthStageProperty())];
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(worldIn, pos, state, chance, fortune);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.isMaxGrowthStage(state) ? this.getProduce() : this.getSeed();
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getSeed());
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isMaxGrowthStage(state);
    }

    @Override
    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return ResynthConfig.PLANTS_GENERAL.canBonemeal && this.canBonemeal();
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.withGrowthStage(meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.getGrowthStage(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{GROWTH_STAGE});
    }

    @Override
    public void onHwylaBodyRequest(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        tooltip.add(TextFormatting.GREEN + "Growth Stage: " + BlockPlantBiochemical.getStageFromBlockMeta(accessor.getMetadata()));
    }

    @Override
    public void onHwylaHeadRequest(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        String blockTitle = tooltip.get(0);
        if (blockTitle.contains("Seeds")) {
            tooltip.clear();
            tooltip.add(0, TextFormatting.GOLD + blockTitle.replace("Seeds", "Flower"));
            tooltip.add(TextFormatting.RED + "Drops: " + blockTitle);
        }
    }

    protected abstract Item getSeed();

    protected abstract Item getProduce();
}

