/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.block;

import com.ki11erwolf.resynth.igtooltip.HwylaDataProvider;
import com.ki11erwolf.resynth.plant.block.BlockPlantBase;
import java.util.List;
import java.util.Random;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public abstract class BlockPlantMetallic
extends BlockPlantBase
implements HwylaDataProvider {
    public static final PropertyInteger GROWTH_STAGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    public static final PropertyDirection FACING = BlockTorch.field_176596_a;
    protected static final AxisAlignedBB[] METALLIC_STEM_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.125, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.25, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.5, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.625, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.75, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.875, 0.625), new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625)};
    private final Block produce;

    public BlockPlantMetallic(Block produce, String name) {
        super(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)GROWTH_STAGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.func_149675_a(true);
        this.func_149647_a(null);
        this.produce = produce;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)GROWTH_STAGE) != 7;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.growStem(worldIn, pos, state);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return METALLIC_STEM_AABB[(Integer)state.func_177229_b((IProperty)GROWTH_STAGE)];
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)GROWTH_STAGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{GROWTH_STAGE, FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)GROWTH_STAGE, (Comparable)Integer.valueOf(meta));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        Item item = this.getSeedItem();
        return item == null ? ItemStack.field_190927_a : new ItemStack(item);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Item item = this.getSeedItem();
        if (item != null) {
            drops.add((Object)new ItemStack(item));
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(worldIn, pos, state, chance, fortune);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int i = (Integer)state.func_177229_b((IProperty)GROWTH_STAGE);
        state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this.produce || i != 7) continue;
            state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
            break;
        }
        return state;
    }

    @Override
    protected void onGrowApproved(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i = (Integer)state.func_177229_b((IProperty)GROWTH_STAGE);
        if (i < 7) {
            IBlockState newState = state.func_177226_a((IProperty)GROWTH_STAGE, (Comparable)Integer.valueOf(i + 1));
            worldIn.func_180501_a(pos, newState, 2);
        } else {
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this.produce) continue;
                return;
            }
            pos = pos.func_177972_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
            IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
            Block block = soil.func_177230_c();
            if (worldIn.func_175623_d(pos) && (block.canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) || block == Blocks.field_150346_d || block == Blocks.field_150349_c)) {
                worldIn.func_175656_a(pos, this.produce.func_176223_P());
            }
        }
        ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
    }

    private void growStem(World worldIn, BlockPos pos, IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)GROWTH_STAGE) + MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)GROWTH_STAGE, (Comparable)Integer.valueOf(Math.min(7, i))), 2);
    }

    @Override
    public void onHwylaBodyRequest(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        tooltip.add(TextFormatting.GREEN + "Growth Stage: " + BlockPlantMetallic.getStageFromBlockMeta(accessor.getMetadata()));
    }

    @Override
    public void onHwylaHeadRequest(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        String blockTitle = tooltip.get(0);
        if (blockTitle.contains("Seeds")) {
            tooltip.clear();
            tooltip.add(0, TextFormatting.GOLD + blockTitle.replace("Seeds", "Plant"));
            tooltip.add(TextFormatting.RED + "Drops: " + blockTitle);
        }
    }

    protected abstract Item getSeedItem();
}

