/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.item;

import com.ki11erwolf.resynth.ResynthConfig;
import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.ResynthTabProduce;
import com.ki11erwolf.resynth.item.ResynthItem;
import com.ki11erwolf.resynth.plant.PlantSetBiochemical;
import com.ki11erwolf.resynth.plant.item.ItemPlantSeeds;
import com.ki11erwolf.resynth.util.MathUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public abstract class ItemPlantProduceBulb
extends ResynthItem {
    private static final String PREFIX = "mobproduce";
    private final ItemPlantSeeds plantSeeds;
    private final PlantSetBiochemical plantSet;

    public ItemPlantProduceBulb(String name, ItemPlantSeeds seeds, PlantSetBiochemical set) {
        super(name, PREFIX);
        this.plantSet = set;
        this.func_77637_a(ResynthTabProduce.RESYNTH_TAB_PRODUCE);
        this.plantSeeds = seeds;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Can be thrown for a chance at getting more seeds.");
        tooltip.add("Can be smelted to obtain the resource.");
        tooltip.add("");
        tooltip.add(TextFormatting.GOLD + "Seed Drop Chance (Mob): " + this.plantSet.getTextualMobSeedDropChance());
        tooltip.add(TextFormatting.GREEN + "Seed Drop Chance (Produce): " + this.plantSet.getTextualProduceSeedDropChance());
        tooltip.add(TextFormatting.AQUA + "Seed Drop Chance (Mystical Seed Pod): " + this.plantSet.getTextualPodSeedDropChance());
        tooltip.add(TextFormatting.RED + "Resource Count (Smelting): x" + this.plantSet.getResult().func_190916_E());
        tooltip.add(TextFormatting.DARK_PURPLE + "Plant Growth Chance: " + this.plantSet.getTextualPlantGrowthChance());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (!playerIn.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        if (ResynthConfig.PLANTS_GENERAL.produceDropSeeds) {
            this.throwItem(worldIn, playerIn);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    protected void throwItem(final World worldIn, EntityPlayer playerIn) {
        worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187595_bc, SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.field_72995_K) {
            EntityEnderPearl ep = new EntityEnderPearl(worldIn, (EntityLivingBase)playerIn){

                protected void func_70184_a(RayTraceResult result) {
                    try {
                        if (!worldIn.field_72995_K && MathUtil.chance(ItemPlantProduceBulb.this.getSeedSpawnChance())) {
                            ItemPlantSeeds.addEffects(worldIn, result.func_178782_a());
                            worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)result.func_178782_a().func_177958_n(), (double)result.func_178782_a().func_177956_o(), (double)result.func_178782_a().func_177952_p(), new ItemStack((Item)ItemPlantProduceBulb.this.plantSeeds)));
                        }
                    }
                    catch (Exception e) {
                        ResynthMod.getLogger().error("Failed to spawn seeds from bulb entity", (Throwable)e);
                    }
                    finally {
                        try {
                            this.func_70106_y();
                        }
                        catch (Exception e) {
                            ResynthMod.getLogger().error("Failed to kill off bulb entity", (Throwable)e);
                        }
                    }
                }
            };
            ep.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 1.0f);
            worldIn.func_72838_d((Entity)ep);
        }
    }

    protected abstract float getSeedSpawnChance();
}

