/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.item;

import com.ki11erwolf.resynth.ResynthTabSeeds;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.item.ResynthItem;
import com.ki11erwolf.resynth.plant.PlantSetBiochemical;
import com.ki11erwolf.resynth.plant.PlantSetCrystalline;
import com.ki11erwolf.resynth.plant.PlantSetMetallic;
import com.ki11erwolf.resynth.plant.block.BlockPlantBase;
import com.ki11erwolf.resynth.plant.block.BlockPlantBiochemical;
import com.ki11erwolf.resynth.plant.block.BlockPlantCrystalline;
import com.ki11erwolf.resynth.plant.block.BlockPlantMetallic;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class ItemPlantSeeds
extends ResynthItem
implements IPlantable {
    protected static final String PREFIX = "seed";
    private final Block plant;
    private final PlantSetBiochemical setBiochemical;
    private final PlantSetCrystalline setCrystalline;
    private final PlantSetMetallic setMetallic;

    public ItemPlantSeeds(BlockPlantBase plant, String name, PlantSetBiochemical biochemical, PlantSetMetallic metallic, PlantSetCrystalline crystalline) {
        super(name, PREFIX);
        this.setBiochemical = biochemical;
        this.setCrystalline = crystalline;
        this.setMetallic = metallic;
        this.plant = plant;
        this.func_77637_a(ResynthTabSeeds.RESYNTH_TAB_SEEDS);
    }

    public ItemPlantSeeds(BlockPlantBase plant, String name, PlantSetBiochemical biochemical) {
        this(plant, name, biochemical, null, null);
    }

    public ItemPlantSeeds(BlockPlantBase plant, String name, PlantSetMetallic metallic) {
        this(plant, name, null, metallic, null);
    }

    public ItemPlantSeeds(BlockPlantBase plant, String name, PlantSetCrystalline crystalline) {
        this(plant, name, null, null, crystalline);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        IBlockState state = worldIn.func_180495_p(pos);
        if (facing == EnumFacing.UP && player.func_175151_a(pos.func_177972_a(facing), facing, itemstack) && worldIn.func_180495_p(pos).func_177230_c() == ResynthBlocks.BLOCK_MINERAL_SOIL && worldIn.func_175623_d(pos.func_177984_a())) {
            worldIn.func_175656_a(pos.func_177984_a(), this.plant.func_176223_P());
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos.func_177984_a(), itemstack);
            }
            itemstack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.plant.func_176223_P();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Place on Mineral Soil.");
        BlockPlantBase base = (BlockPlantBase)this.plant;
        if (base instanceof BlockPlantCrystalline) {
            tooltip.add("Spawns randomly when mining the ore");
        } else if (base instanceof BlockPlantMetallic) {
            tooltip.add("Spawns randomly when blowing up the ore");
        } else if (base instanceof BlockPlantBiochemical) {
            tooltip.add("Spawns randomly when killing the mob");
        }
        tooltip.add("");
        if (this.setMetallic != null) {
            tooltip.add(TextFormatting.GOLD + "Seed Drop Chance (Ore): " + this.setMetallic.getTextualOreSeedDropChance());
            tooltip.add(TextFormatting.GREEN + "Seed Drop Chance (Produce): " + this.setMetallic.getTextualProduceSeedDropChance());
            tooltip.add(TextFormatting.DARK_PURPLE + "Plant Growth Chance: " + this.setMetallic.getTextualPlantGrowthChance());
        } else if (this.setCrystalline != null) {
            tooltip.add(TextFormatting.GOLD + "Seed Drop Chance (Ore): " + this.setCrystalline.getTextualOreSeedDropChance());
            tooltip.add(TextFormatting.GREEN + "Seed Drop Chance (Produce): " + this.setCrystalline.getTextualProduceSeedDropChance());
            tooltip.add(TextFormatting.DARK_PURPLE + "Plant Growth Chance: " + this.setCrystalline.getTextualPlantGrowthChance());
        } else if (this.setBiochemical != null) {
            tooltip.add(TextFormatting.GOLD + "Seed Drop Chance (Mob): " + this.setBiochemical.getTextualMobSeedDropChance());
            tooltip.add(TextFormatting.GREEN + "Seed Drop Chance (Produce): " + this.setBiochemical.getTextualProduceSeedDropChance());
            tooltip.add(TextFormatting.AQUA + "Seed Drop Chance (Mystical Seed Pod): " + this.setBiochemical.getTextualPodSeedDropChance());
            tooltip.add(TextFormatting.DARK_PURPLE + "Plant Growth Chance: " + this.setBiochemical.getTextualPlantGrowthChance());
        }
    }

    public static void addEffects(World worldIn, BlockPos pos) {
        worldIn.func_184133_a(null, pos, SoundEvents.field_193807_ew, SoundCategory.BLOCKS, 0.5f, 1.0f);
    }
}

