/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.versioning;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.versioning.DefaultVersionMessage;
import com.ki11erwolf.resynth.versioning.IVersionMessage;
import com.ki11erwolf.resynth.versioning.ModVersionObject;
import com.ki11erwolf.resynth.versioning.Status;
import com.ki11erwolf.resynth.versioning.VersionManagerBuilder;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.gui.NotificationModUpdateScreen;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ModVersionManager {
    private static final Map<String, ModVersionObject> modVersionObjects = new HashMap<String, ModVersionObject>();
    private static Logger LOG;
    private final String modid;
    private boolean enabled;
    private boolean enableConsoleMessage;
    private boolean useForgeUpdateURL;
    private URL updateURL;
    private List<String> givenVersionJsonURLS;
    private IVersionMessage updateMessages;
    private static boolean isSSLDisabled;
    private static SSLSocketFactory defaultSocketFactory;
    private static HostnameVerifier defaultHostnameVerifier;

    public ModVersionManager(VersionManagerBuilder builder) {
        this(builder, DefaultVersionMessage.INSTANCE);
    }

    public ModVersionManager(VersionManagerBuilder builder, IVersionMessage updateMessages) {
        LOG = ResynthMod.getLogger();
        this.modid = builder.modid;
        this.enabled = builder.enabled;
        this.enableConsoleMessage = builder.enableConsoleMessage;
        this.updateURL = builder.updateURL;
        this.useForgeUpdateURL = builder.useForgeUpdateURL;
        this.givenVersionJsonURLS = builder.givenUpdateJsonURLS;
        this.updateMessages = updateMessages;
    }

    public ModVersionObject preInit() {
        ModVersionManager.disableSSLVerification();
        if (!this.validate()) {
            LOG.error("Version checker for mod: " + this.modid + " failed validation. Skipping...");
            return null;
        }
        LOG.info("Processing: " + this.givenVersionJsonURLS.size() + " urls for: " + this.modid);
        JsonObject versionJson = null;
        for (String url : this.givenVersionJsonURLS) {
            try {
                URL _url = new URL(url);
                if (_url.getFile() != null) {
                    versionJson = ModVersionManager.getJsonFromURL(url);
                }
                LOG.info("Attempting url: " + url + " for: " + this.modid + "...");
                ModVersionObject attemptVersionObject = new ModVersionObject(this.modid, Minecraft.func_71410_x().func_175600_c(), _url, ModVersionManager.getContainerForMod(this.modid).getVersion(), this.updateMessages, this.enableConsoleMessage);
                if (!attemptVersionObject.parse(versionJson)) {
                    LOG.error("Invalid version json for mod: " + this.modid + "");
                }
                if (attemptVersionObject.isDisabledServerSide()) {
                    LOG.info("Version checking is disabled server side for: " + this.modid + " in url" + url + ". Skipping completely...");
                    return null;
                }
                if (this.updateURL == null) {
                    this.updateURL = new URL(attemptVersionObject.getUpdateURL());
                }
                if (attemptVersionObject != null) {
                    LOG.info("Mod version status: " + attemptVersionObject.toString());
                }
                modVersionObjects.put(this.modid, attemptVersionObject);
                ModVersionManager.enableSSLVerification();
                return attemptVersionObject;
            }
            catch (Exception e) {
                LOG.warn("Could not get version.json content from url: " + url + " | modid: " + this.modid, (Throwable)e);
            }
        }
        ModVersionManager.enableSSLVerification();
        if (versionJson == null) {
            LOG.error("No more version.json urls remaining for mod: " + this.modid + ". Skipping...");
        }
        return null;
    }

    private boolean validate() {
        if (!this.enabled) {
            LOG.info("Version checker for mod: " + this.modid + " is set to disabled. Skipping...");
            return false;
        }
        if (!Loader.isModLoaded((String)this.modid)) {
            LOG.error("Invalid modid: " + this.modid + ". Skipping version checker initialization for this mod...");
            return false;
        }
        if (this.useForgeUpdateURL) {
            URL updateUrl = ModVersionManager.getContainerForMod(this.modid).getUpdateUrl();
            if (updateUrl == null) {
                LOG.error("Version checker for mod: " + this.modid + " is set to use forge update url for mod but is is null or empty. Skipping this url...");
            } else {
                this.givenVersionJsonURLS.add(0, updateUrl.toString());
            }
        }
        if (this.givenVersionJsonURLS.size() == 0) {
            LOG.error("No valid version.json urls available for mod: " + this.modid + ". Skipping...");
            return false;
        }
        return true;
    }

    private static String readUrl(URL url) throws Exception {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            int read;
            StringBuilder buffer = new StringBuilder();
            char[] chars = new char[1024];
            while ((read = reader.read(chars)) != -1) {
                buffer.append(chars, 0, read);
            }
            String string = buffer.toString();
            return string;
        }
    }

    private static JsonObject getJsonFromURL(String url) throws Exception {
        Gson gson = new Gson();
        return (JsonObject)gson.fromJson(ModVersionManager.readUrl(new URL(url)), JsonObject.class);
    }

    private static ModContainer getContainerForMod(String modid) {
        for (ModContainer container : Loader.instance().getActiveModList()) {
            if (!container.getModId().equals(modid)) continue;
            return container;
        }
        for (ModContainer container : Loader.instance().getActiveModList()) {
            if (!container.getModId().toLowerCase().equals(modid.toLowerCase())) continue;
            return container;
        }
        return null;
    }

    private static void updateForgeModVersionState(String modid, ModVersionObject versionObject, String updateURL, GuiMainMenu mainMenu) {
        ModContainer modContainer = ModVersionManager.getContainerForMod(modid);
        if (modContainer == null) {
            LOG.error("Cannot update " + modid + " mod container as it is null...");
            return;
        }
        ForgeVersion.Status forgeStatus = ForgeVersion.Status.PENDING;
        if (versionObject.getStatus() == Status.OUT_OF_DATE) {
            forgeStatus = ForgeVersion.Status.OUTDATED;
        } else if (versionObject.getStatus() == Status.UP_TO_DATE) {
            forgeStatus = ForgeVersion.Status.UP_TO_DATE;
        } else if (versionObject.getStatus() == Status.DEVELOPMENT) {
            forgeStatus = ForgeVersion.Status.AHEAD;
        } else if (versionObject.getStatus() == Status.FAILED) {
            forgeStatus = ForgeVersion.Status.FAILED;
        }
        ComparableVersion forgeComparableVersion = versionObject.getLatestVersionAsString() != null ? new ComparableVersion(versionObject.getRecommendedVersionAsString()) : new ComparableVersion(versionObject.getLatestVersionAsString());
        LinkedHashMap<ComparableVersion, String> forgeChanges = new LinkedHashMap<ComparableVersion, String>();
        if (versionObject.getVersions() != null) {
            for (JsonElement version : versionObject.getVersions()) {
                forgeChanges.put(new ComparableVersion(version.getAsString()), "");
            }
        } else {
            forgeChanges.put(new ComparableVersion(versionObject.getLatestVersionAsString()), "");
            forgeChanges.put(new ComparableVersion(versionObject.getRecommendedVersionAsString()), "");
            forgeChanges.put(new ComparableVersion(versionObject.getCurrentVersionAsString()), "");
        }
        Constructor<?> constructor = ForgeVersion.CheckResult.class.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        if (mainMenu == null) {
            LOG.error("Failed to get main menu gui. Skipping...");
            return;
        }
        try {
            ForgeVersion.CheckResult newCheckResult = (ForgeVersion.CheckResult)constructor.newInstance(forgeStatus, forgeComparableVersion, forgeChanges, updateURL.toString());
            Field f = ForgeVersion.class.getDeclaredField("results");
            f.setAccessible(true);
            Map iWantThis = (Map)f.get("results");
            iWantThis.put(modContainer, newCheckResult);
            f.set(null, iWantThis);
            Field f2 = mainMenu.getClass().getDeclaredField("modUpdateNotification");
            f2.setAccessible(true);
            NotificationModUpdateScreen notificationModUpdateScreen = (NotificationModUpdateScreen)f2.get(mainMenu);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | InvocationTargetException e) {
            LOG.error("Failed to update forge version status. Skipping...", (Throwable)e);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onMainMenuInitialized(GuiScreenEvent event) {
        if (event.getGui() instanceof GuiMainMenu) {
            for (Map.Entry<String, ModVersionObject> versionObject : modVersionObjects.entrySet()) {
                if (!versionObject.getValue().forgeInitialized) {
                    ModVersionManager.updateForgeModVersionState(versionObject.getKey(), versionObject.getValue(), versionObject.getValue().getUpdateURL(), (GuiMainMenu)event.getGui());
                }
                versionObject.getValue().forgeInitialized = true;
            }
        }
    }

    public static void disableSSLVerification() {
        if (!isSSLDisabled) {
            try {
                defaultSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
                defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                HostnameVerifier allHostsValid = (hostname, session) -> true;
                HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                LOG.error("Failed to disable SSL", (Throwable)e);
            }
            isSSLDisabled = true;
        }
    }

    public static void enableSSLVerification() {
        if (defaultSocketFactory != null && defaultHostnameVerifier != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(defaultSocketFactory);
            HttpsURLConnection.setDefaultSSLSocketFactory(defaultSocketFactory);
            isSSLDisabled = false;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPlayerJoined(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            LOG.info("player joined");
            for (ModVersionObject object : modVersionObjects.values()) {
                LOG.info("Version obj: " + object.getModid());
                if (object == null || object.getVersionMessage() == null || !object.enableOutOfDateVersionChatMessages()) continue;
                EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
                if (object.getStatus() == Status.OUT_OF_DATE) {
                    player.func_145747_a((ITextComponent)new TextComponentString(object.getVersionMessage().getOutOfDateMessage(object)));
                }
                if (object.getStatus() == Status.DEVELOPMENT) {
                    player.func_145747_a((ITextComponent)new TextComponentString(object.getVersionMessage().getDevelopmentMessage(object)));
                }
                if (object.getStatus() != Status.FAILED) continue;
                player.func_145747_a((ITextComponent)new TextComponentString(object.getVersionMessage().getFailureMessage(object)));
            }
        }
    }

    static {
        isSSLDisabled = false;
    }
}

