/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.versioning;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.versioning.IVersionMessage;
import com.ki11erwolf.resynth.versioning.Status;
import java.net.URL;
import java.util.Map;

public class ModVersionObject {
    private final String modid;
    private URL url;
    private boolean isDisabledServerSide;
    private int iCurrentVersion;
    private int iLatestVersion;
    private int iRecommendedVersion;
    private String sCurrentVersion;
    private String sLatestVersion;
    private String sRecommendedVersion;
    private String minecraftVersion;
    private String updateURL;
    private JsonObject jsonFileContent;
    private JsonArray versions;
    private Status status = Status.FAILED;
    boolean forgeInitialized = false;
    private IVersionMessage versionMessage;
    private boolean enableMessage;

    ModVersionObject(String modid, String minecraftVersion, URL url, String currentVersion, IVersionMessage messages, boolean enableMessage) {
        this.modid = modid;
        this.minecraftVersion = minecraftVersion;
        this.sCurrentVersion = currentVersion;
        this.versionMessage = messages;
        this.enableMessage = enableMessage;
    }

    boolean parse(JsonObject versionJson) {
        if (versionJson.has("enable")) {
            boolean bl = this.isDisabledServerSide = !versionJson.get("enable").getAsBoolean();
        }
        if (versionJson.has("homepage")) {
            this.updateURL = versionJson.get("homepage").getAsString();
        }
        if (versionJson.has("promos")) {
            this.parseForgeVersionJson(versionJson.getAsJsonObject("promos"));
        }
        if (versionJson.has(this.minecraftVersion) && versionJson.get(this.minecraftVersion).isJsonObject()) {
            this.versions = new JsonArray();
            for (Map.Entry set : versionJson.get(this.minecraftVersion).getAsJsonObject().entrySet()) {
                this.versions.add((String)set.getKey());
            }
        }
        this.parseVersions(versionJson);
        if (versionJson.has(this.modid)) {
            this.parseModidJson(versionJson.getAsJsonObject(this.modid));
        }
        this.jsonFileContent = versionJson;
        return this.validate();
    }

    public boolean isDisabledServerSide() {
        return this.isDisabledServerSide;
    }

    public String getRecommendedVersionAsString() {
        return this.sRecommendedVersion;
    }

    public int getRecommendedVersionAsInteger() {
        return this.iRecommendedVersion;
    }

    public String getModid() {
        return this.modid;
    }

    public URL getUrl() {
        return this.url;
    }

    public int getCurrentVersionAsInteger() {
        return this.iCurrentVersion;
    }

    public int getLatestVersionAsInteger() {
        return this.iLatestVersion;
    }

    public String getCurrentVersionAsString() {
        return this.sCurrentVersion;
    }

    public String getLatestVersionAsString() {
        return this.sLatestVersion;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public String getUpdateURL() {
        return this.updateURL;
    }

    public JsonObject getJsonFileContent() {
        return this.jsonFileContent;
    }

    public JsonArray getVersions() {
        return this.versions;
    }

    public Status getStatus() {
        return this.status;
    }

    private boolean validate() {
        if (this.sLatestVersion == null) {
            ResynthMod.getLogger().error("Failed to get latest version for: " + this.modid + " | url: " + this.url.getFile());
            return false;
        }
        if (this.sCurrentVersion == null) {
            ResynthMod.getLogger().error("Failed to get current version for: " + this.modid);
            return false;
        }
        this.finalizeVariables();
        return this.jsonFileContent != null;
    }

    private void finalizeVariables() {
        try {
            this.iLatestVersion = Integer.parseInt(this.sLatestVersion.replace(" ", "").replace(".", "").replace("[", "").replace("]", "").replace("v", "").replace("V", "").replace("version", "").replace("Version", "").replace("VERSION", "").replace("-", "").replace("_", ""));
        }
        catch (NumberFormatException e) {
            this.iLatestVersion = 0;
            ResynthMod.getLogger().warn("Failed to process iLatestVersion | mod: " + this.modid);
        }
        try {
            this.iRecommendedVersion = Integer.parseInt(this.sRecommendedVersion.replace(" ", "").replace(".", "").replace("[", "").replace("]", "").replace("v", "").replace("V", "").replace("version", "").replace("Version", "").replace("VERSION", "").replace("-", "").replace("_", ""));
        }
        catch (NumberFormatException e) {
            this.iRecommendedVersion = 0;
            ResynthMod.getLogger().warn("Failed to process iRecommendedVersion | mod: " + this.modid);
        }
        try {
            this.iCurrentVersion = Integer.parseInt(this.sCurrentVersion.replace(" ", "").replace(".", "").replace("[", "").replace("]", "").replace("v", "").replace("V", "").replace("version", "").replace("Version", "").replace("VERSION", "").replace("-", "").replace("_", ""));
        }
        catch (NumberFormatException e) {
            this.iCurrentVersion = 0;
            ResynthMod.getLogger().warn("Failed to process iCurrentVersion | mod: " + this.modid);
        }
        if (this.iLatestVersion == 0 && this.iRecommendedVersion == 0 || this.iCurrentVersion == 0) {
            this.status = Status.FAILED;
        }
        if (this.iCurrentVersion < this.iLatestVersion) {
            this.status = Status.OUT_OF_DATE;
        }
        if (this.iCurrentVersion == this.iLatestVersion) {
            this.status = Status.UP_TO_DATE;
        }
        if (this.iCurrentVersion > this.iLatestVersion) {
            this.status = Status.DEVELOPMENT;
        }
    }

    private void parseForgeVersionJson(JsonObject promos) {
        if (promos.has("latest")) {
            this.sLatestVersion = promos.get("latest").getAsString();
        }
        if (promos.has("recommended")) {
            this.sRecommendedVersion = promos.get("recommended").getAsString();
        }
        if (promos.has(this.minecraftVersion + "-latest")) {
            this.sLatestVersion = promos.get(this.minecraftVersion + "-latest").getAsString();
        }
        if (promos.has(this.minecraftVersion + "-recommended")) {
            this.sRecommendedVersion = promos.get(this.minecraftVersion + "-recommended").getAsString();
        }
    }

    private void parseVersions(JsonObject versionJson) {
        JsonObject latest;
        if (versionJson.has("latest")) {
            if (versionJson.get("latest").isJsonObject()) {
                latest = versionJson.getAsJsonObject("latest");
                if (latest.has("all")) {
                    this.sLatestVersion = latest.get("all").getAsString();
                }
                if (latest.has(this.minecraftVersion)) {
                    this.sLatestVersion = latest.get(this.minecraftVersion).getAsString();
                }
            } else if (versionJson.get("latest").isJsonPrimitive()) {
                this.sLatestVersion = versionJson.get("latest").getAsString();
            }
        }
        if (versionJson.has("recommended")) {
            if (versionJson.get("recommended").isJsonObject()) {
                latest = versionJson.getAsJsonObject("recommended");
                if (latest.has("all")) {
                    this.sLatestVersion = latest.get("all").getAsString();
                }
                if (latest.has(this.minecraftVersion)) {
                    this.sLatestVersion = latest.get(this.minecraftVersion).getAsString();
                }
            } else if (versionJson.get("recommended").isJsonPrimitive()) {
                this.sLatestVersion = versionJson.get("recommended").getAsString();
            }
        }
    }

    private void parseModidJson(JsonObject modidJson) {
        if (modidJson.has("latest")) {
            this.sLatestVersion = modidJson.get("latest").getAsString();
        }
        if (modidJson.has("recommended")) {
            this.sRecommendedVersion = modidJson.get("recommended").getAsString();
        }
        if (modidJson.has(this.minecraftVersion)) {
            JsonObject versionsJson = modidJson.getAsJsonObject(this.minecraftVersion);
            if (versionsJson.has("latest")) {
                this.sLatestVersion = versionsJson.get("latest").getAsString();
            }
            if (versionsJson.has("recommended")) {
                this.sRecommendedVersion = versionsJson.get("recommended").getAsString();
            }
            if (versionsJson.has("versions")) {
                this.versions = versionsJson.getAsJsonArray("versions");
            }
        }
    }

    public String toString() {
        return String.format(this.modid + ".versioning {status: %s, minecraft-version: %s, latest-version: %s(%s), recommended-version: %s(%s) current-version: %s(%s)}", this.status.toString(), this.minecraftVersion, this.sLatestVersion, this.iLatestVersion, this.sRecommendedVersion, this.iRecommendedVersion, this.sCurrentVersion, this.iCurrentVersion);
    }

    public IVersionMessage getVersionMessage() {
        return this.versionMessage;
    }

    public boolean enableOutOfDateVersionChatMessages() {
        return this.enableMessage;
    }
}

