/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.analytics;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.ResynthSSL;
import com.ki11erwolf.resynth.analytics.Event;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.GeneralConfig;
import dmurph.tracking.AnalyticsConfigData;
import dmurph.tracking.JGoogleAnalyticsTracker;
import org.apache.logging.log4j.Logger;

public final class ResynthAnalytics {
    private static final Logger LOG = ResynthMod.getNewLogger();
    private static final boolean ENABLED = ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class).isAnalyticsEnabled();
    private static final String CODE = "UA-127648959-1";
    private static final String RESYNTH_DOMAIN = "https://resynth-minecraft-mod.github.io";
    private static final String IDENTIFIER_PAGE = "/jar";
    private static final String TITLE = "Resynth - Jar";
    private static final JGoogleAnalyticsTracker ANALYTICS;

    private ResynthAnalytics() {
    }

    public static void send(Event e) {
        if (!ENABLED) {
            LOG.info("Analytics disabled! Event prevented from sending.");
            return;
        }
        ResynthSSL.disableSSL();
        LOG.info("Analytics enabled! Sending analytics event: " + e.getClass().getName());
        ANALYTICS.makeCustomRequest(e);
        ResynthSSL.enableSSL();
    }

    static void setEventHost(Event event) {
        event.setHostName(RESYNTH_DOMAIN);
        event.setPageURL(IDENTIFIER_PAGE);
        event.setPageTitle(TITLE);
    }

    static {
        ResynthSSL.disableSSL();
        ANALYTICS = new JGoogleAnalyticsTracker(new AnalyticsConfigData(CODE), JGoogleAnalyticsTracker.GoogleAnalyticsVersion.V_4_7_2);
    }
}

