/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.block;

import com.ki11erwolf.resynth.block.ResynthBlock;
import com.ki11erwolf.resynth.block.tileEntity.ResynthTileEntity;
import com.ki11erwolf.resynth.block.tileEntity.TileEntityMineralSoil;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.MineralSoilConfig;
import com.ki11erwolf.resynth.item.ItemMineralHoe;
import com.ki11erwolf.resynth.item.ResynthItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockMineralSoil
extends ResynthTileEntity<TileEntityMineralSoil>
implements ItemMineralHoe.InfoProvider {
    private static final MineralSoilConfig CONFIG = ResynthConfig.GENERAL_CONFIG.getCategory(MineralSoilConfig.class);
    private static final IntegerProperty STAGE = IntegerProperty.func_177719_a((String)"stage", (int)0, (int)4);
    private static final VoxelShape MINERAL_SOIL_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    BlockMineralSoil() {
        super(Block.Properties.func_200945_a((Material)Material.field_151577_b).func_200943_b(2.0f).func_200947_a(SoundType.field_185849_b), "mineral_soil");
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ResynthBlock.setDescriptiveTooltip(tooltip, this);
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return MINERAL_SOIL_SHAPE;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private void updateState(float mineralContent, World world, IBlockState state, BlockPos pos) {
        if ((double)mineralContent > 49.9) {
            world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)));
        } else if ((double)mineralContent > 39.9) {
            world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(3)));
        } else if ((double)mineralContent > 29.9) {
            world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(2)));
        } else if ((double)mineralContent > 19.9) {
            world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(1)));
        } else {
            world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{STAGE});
    }

    public Item getItemDropped(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return Item.func_150898_a((Block)Blocks.field_150346_d);
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (!(tileentity instanceof TileEntityMineralSoil)) {
                super.func_196243_a(state, world, pos, newState, isMoving);
            }
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack((IItemProvider)ResynthItems.ITEM_MINERAL_CRYSTAL));
            assert (tileentity != null);
            assert (tileentity instanceof TileEntityMineralSoil);
            float content = ((TileEntityMineralSoil)tileentity).getMineralPercentage();
            int rocks = (int)(((double)content - CONFIG.getStartingMineralContent()) / CONFIG.getMineralRockWorth());
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack((IItemProvider)ResynthItems.ITEM_MINERAL_ROCK, rocks));
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Override
    public Class<TileEntityMineralSoil> getTileEntityClass() {
        return TileEntityMineralSoil.class;
    }

    @Override
    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return new TileEntityMineralSoil();
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        float increase;
        ItemStack usedItem = player.func_184586_b(hand);
        TileEntityMineralSoil entityMineralSoil = (TileEntityMineralSoil)((Object)this.getTileEntity((IBlockReader)world, pos));
        float mineralContent = entityMineralSoil.getMineralPercentage();
        if (mineralContent >= 50.0f) {
            return false;
        }
        if (usedItem.func_77973_b() == ResynthItems.ITEM_MINERAL_ROCK) {
            increase = (float)CONFIG.getMineralRockWorth();
        } else if (usedItem.func_77973_b() == ResynthItems.ITEM_DENSE_MINERAL_ROCK) {
            increase = (float)CONFIG.getMineralRockWorth() * 9.0f;
        } else {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_184812_l_()) {
            usedItem.func_190918_g(1);
        }
        entityMineralSoil.increaseMineralPercentage(increase);
        this.updateState(entityMineralSoil.getMineralPercentage(), world, state, pos);
        if (CONFIG.isChatMessageEnabled()) {
            player.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"misc.resynth.mineral_content", (Object[])new Object[]{Float.valueOf(entityMineralSoil.getMineralPercentage())}) + "%"));
        }
        return true;
    }

    @Override
    public String getInfo(World world, BlockPos pos) {
        TileEntityMineralSoil entity = (TileEntityMineralSoil)((Object)this.getTileEntity((IBlockReader)world, pos));
        if (entity == null) {
            return "Error";
        }
        return I18n.func_135052_a((String)"misc.resynth.mineral_content", (Object[])new Object[]{Float.valueOf(entity.getMineralPercentage())});
    }
}

