/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.block;

import com.ki11erwolf.resynth.block.ResynthBlock;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.SeedPodConfig;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.PublicPlantSetRegistry;
import com.ki11erwolf.resynth.util.MathUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class BlockSeedPod
extends ResynthBlock
implements IPlantable {
    private static final SeedPodConfig CONFIG = ResynthConfig.GENERAL_CONFIG.getCategory(SeedPodConfig.class);
    private static final VoxelShape SEED_POD_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)14.0, (double)15.0, (double)14.0);

    BlockSeedPod() {
        super(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_185850_c), "seed_pod");
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public boolean func_200124_e(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        Vec3d vec3d = state.func_191059_e(worldIn, pos);
        return SEED_POD_SHAPE.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public int func_200011_d(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public IBlockState getPlant(IBlockReader world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        BlockSeedPod.setDescriptiveTooltip(tooltip, this);
    }

    private boolean isValidGround(IBlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l;
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        if (state.func_177230_c() == this) {
            return worldIn.func_180495_p(blockpos).canSustainPlant((IBlockReader)worldIn, blockpos, EnumFacing.UP, (IPlantable)this);
        }
        return this.isValidGround(worldIn.func_180495_p(blockpos));
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReaderBase)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nonnull
    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        if (!CONFIG.areDropsEnabled()) {
            return this;
        }
        PlantSet[] plantSets = PublicPlantSetRegistry.getSets(PublicPlantSetRegistry.SetType.BIOCHEMICAL);
        PlantSet randomSet = plantSets[MathUtil.getRandomIntegerInRange(0, plantSets.length - 1)];
        return randomSet.getSeedsItem();
    }
}

