/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config;

import com.ki11erwolf.resynth.config.ConfigCategory;
import com.ki11erwolf.resynth.config.ConfigValue;
import java.util.Objects;

public class BooleanConfigValue
implements ConfigValue {
    private final String uniqueName;
    private final String comment;
    private final boolean defaultValue;
    private boolean value;

    public BooleanConfigValue(String uniqueName, String comment, boolean defaultValue, ConfigCategory category) {
        this.uniqueName = Objects.requireNonNull(uniqueName).replace(' ', '-');
        this.comment = Objects.requireNonNull(comment);
        this.defaultValue = defaultValue;
        category.registerConfigValue(this);
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public String getComment() {
        return this.comment + "\n(type=boolean, default=" + this.defaultValue + ")";
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setValue(Object value) {
        this.value = Boolean.parseBoolean(String.valueOf(value));
    }

    @Override
    public Object get() {
        return this.getValue();
    }
}

