/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config;

import com.ki11erwolf.resynth.config.ConfigCategory;
import com.ki11erwolf.resynth.config.ConfigValue;
import java.util.Objects;

public class IntegerConfigValue
implements ConfigValue {
    private final String uniqueName;
    private final String comment;
    private final int defaultValue;
    private final int min;
    private final int max;
    private int value;

    public IntegerConfigValue(String uniqueName, String comment, int defaultValue, int min, int max, ConfigCategory category) {
        this.uniqueName = Objects.requireNonNull(uniqueName).replace(' ', '-');
        this.comment = Objects.requireNonNull(comment);
        this.defaultValue = defaultValue;
        this.min = min;
        this.max = max;
        category.registerConfigValue(this);
    }

    public IntegerConfigValue(String uniqueName, String comment, int defaultValue, ConfigCategory category) {
        this(uniqueName, comment, defaultValue, 0, 0, category);
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public String getComment() {
        return this.comment + (this.min == 0 && this.max == 0 ? "\n(type=integer, min=-2147483648, max=2147483647, default=" + this.defaultValue + ")" : "\n(type=integer, min=" + this.min + ", max=" + this.max + ", default=" + this.defaultValue + ")");
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setValue(Object value) {
        try {
            this.value = Integer.parseInt(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            this.value = this.defaultValue;
        }
        if (this.max == 0 && this.min == 0) {
            return;
        }
        if (this.value > this.max) {
            this.value = this.max;
        }
        if (this.value < this.min) {
            this.value = this.min;
        }
    }

    @Override
    public Object get() {
        return this.getValue();
    }
}

