/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.item;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.MineralHoeConfig;
import com.ki11erwolf.resynth.item.ResynthItem;
import com.ki11erwolf.resynth.item.ResynthItems;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Logger;

public class ItemMineralHoe
extends ResynthItem<ItemMineralHoe> {
    private static final MineralHoeConfig CONFIG = ResynthConfig.GENERAL_CONFIG.getCategory(MineralHoeConfig.class);
    private static final Logger LOG = ResynthMod.getNewLogger();
    private static final String NBT_TAG_CHARGES = "charges";

    ItemMineralHoe() {
        super(new Item.Properties().func_200917_a(1), "mineral_hoe");
    }

    private void ensureNBT(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            nbt.func_74768_a(NBT_TAG_CHARGES, Math.min(CONFIG.getInitialCharges(), 2));
            stack.func_77982_d(nbt);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        this.ensureNBT(stack);
        if (stack.func_77978_p() != null) {
            tooltip.add(ItemMineralHoe.getFormattedTooltip("mineral_hoe_charges", TextFormatting.GOLD, stack.func_77978_p().func_74762_e(NBT_TAG_CHARGES)));
        }
        ItemMineralHoe.setDescriptiveTooltip(tooltip, this);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        this.ensureNBT(stack);
        int charges = stack.func_77978_p().func_74762_e(NBT_TAG_CHARGES);
        if (charges >= CONFIG.getMaxCharges()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_184812_l_() || this.takeCharge(player)) {
            stack.func_77978_p().func_74768_a(NBT_TAG_CHARGES, charges + 1);
            world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_193808_ex, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    private boolean takeCharge(EntityPlayer player) {
        for (ItemStack itemStack : player.field_71069_bz.func_75138_a()) {
            if (itemStack.func_77973_b() != ResynthItems.ITEM_MINERAL_CRYSTAL) continue;
            itemStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    @Nonnull
    public EnumActionResult func_195939_a(ItemUseContext context) {
        if (!CONFIG.isEnabled()) {
            return EnumActionResult.FAIL;
        }
        this.ensureNBT(context.func_195996_i());
        if (context.func_195999_j() == null) {
            LOG.warn("Invalid player using the Mineral Hoe...");
            return EnumActionResult.FAIL;
        }
        Block block = context.func_195991_k().func_180495_p(context.func_195995_a()).func_177230_c();
        if (context.func_195999_j().func_184812_l_() && context.func_195999_j().func_70093_af() && this.tryGrowPlant(block, context)) {
            return EnumActionResult.SUCCESS;
        }
        if (block instanceof InfoProvider) {
            this.getInfo(block, context);
            return EnumActionResult.SUCCESS;
        }
        if (context.func_195999_j().func_70093_af()) {
            return this.func_77659_a(context.func_195991_k(), context.func_195999_j(), EnumHand.MAIN_HAND).func_188397_a();
        }
        if (context.func_195999_j().func_184812_l_()) {
            return this.replace(context);
        }
        if (context.func_195996_i().func_77978_p() == null) {
            return EnumActionResult.FAIL;
        }
        int charges = context.func_195996_i().func_77978_p().func_74762_e(NBT_TAG_CHARGES);
        if (charges < 1) {
            if (CONFIG.playFailSound()) {
                context.func_195991_k().func_184133_a(context.func_195999_j(), context.func_195995_a(), SoundEvents.field_187685_dH, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return EnumActionResult.FAIL;
        }
        EnumActionResult result = this.replace(context);
        if (result == EnumActionResult.SUCCESS) {
            context.func_195996_i().func_77978_p().func_74768_a(NBT_TAG_CHARGES, charges - 1);
        }
        return result;
    }

    private boolean tryGrowPlant(Block block, ItemUseContext context) {
        if (block instanceof IGrowable) {
            if (!context.func_195991_k().field_72995_K) {
                ((IGrowable)block).func_176474_b(context.func_195991_k(), field_77697_d, context.func_195995_a(), context.func_195991_k().func_180495_p(context.func_195995_a()));
            }
            return true;
        }
        return false;
    }

    private void getInfo(Block block, ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K && context.func_195999_j() != null) {
            context.func_195999_j().func_145747_a((ITextComponent)new TextComponentString(((InfoProvider)block).getInfo(context.func_195991_k(), context.func_195995_a())));
        }
    }

    private EnumActionResult replace(ItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        IBlockState source = world.func_180495_p(pos = context.func_195995_a());
        if ((source.func_177230_c() == Blocks.field_150346_d || source.func_177230_c() == Blocks.field_196658_i) && context.func_196000_l() != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
            world.func_175656_a(pos, ResynthBlocks.BLOCK_MINERAL_SOIL.func_176223_P());
            if (CONFIG.showParticles()) {
                ItemMineralHoe.spawnParticles(world, pos.func_177984_a());
            }
            world.func_184133_a(context.func_195999_j(), pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void spawnParticles(World worldIn, BlockPos pos) {
        double d = field_77697_d.nextGaussian() * 0.02;
        int amount = 5;
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_185904_a() != Material.field_151579_a) {
            for (int i = 0; i < amount; ++i) {
                worldIn.func_195594_a((IParticleData)Particles.field_197631_x, (double)((float)pos.func_177958_n() + field_77697_d.nextFloat()), (double)pos.func_177956_o() + (double)field_77697_d.nextFloat() * iblockstate.func_196954_c((IBlockReader)worldIn, pos).func_197758_c(EnumFacing.Axis.Y), (double)((float)pos.func_177952_p() + field_77697_d.nextFloat()), d, d, d);
            }
        } else {
            for (int i1 = 0; i1 < amount; ++i1) {
                worldIn.func_195594_a((IParticleData)Particles.field_197631_x, (double)((float)pos.func_177958_n() + field_77697_d.nextFloat()), (double)pos.func_177956_o() + (double)field_77697_d.nextFloat() * 1.0, (double)((float)pos.func_177952_p() + field_77697_d.nextFloat()), d, d, d);
            }
        }
    }

    public static interface InfoProvider {
        public String getInfo(World var1, BlockPos var2);
    }
}

