/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.item;

import com.ki11erwolf.resynth.ResynthTabs;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.GeneralConfig;
import com.ki11erwolf.resynth.item.ResynthItems;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ResynthItem<T extends ResynthItem>
extends Item {
    private boolean isQueued = false;

    ResynthItem(Item.Properties properties, String name) {
        super(ResynthItem.setItemGroup(properties));
        this.setRegistryName(name);
    }

    public ResynthItem(String name) {
        this(new Item.Properties(), name);
    }

    public ResynthItem(String name, ItemGroup group) {
        super(new Item.Properties().func_200916_a(group));
        this.setRegistryName(name);
    }

    public ResynthItem(Item.Properties properties, String name, String prefix) {
        super(ResynthItem.setItemGroup(properties));
        this.setRegistryName(prefix + name);
    }

    T queueRegistration() {
        if (this.isQueued) {
            throw new IllegalStateException(String.format("Item: %s already queued for registration.", ((Object)((Object)this)).getClass().getCanonicalName()));
        }
        ResynthItems.INSTANCE.queueForRegistration(this);
        this.isQueued = true;
        return (T)((Object)this);
    }

    private static Item.Properties setItemGroup(Item.Properties properties) {
        properties.func_200916_a(ResynthTabs.TAB_RESYNTH);
        return properties;
    }

    protected static ITextComponent stringToTextComponent(String text) {
        return new TextComponentString(text);
    }

    static ITextComponent getTooltip(String key) {
        return ResynthItem.stringToTextComponent(TextFormatting.GRAY + I18n.func_135052_a((String)("tooltip.item.resynth." + key), (Object[])new Object[0]));
    }

    protected static ITextComponent getFormattedTooltip(String key, TextFormatting color, Object ... params) {
        return ResynthItem.stringToTextComponent(color + I18n.func_135052_a((String)("tooltip.item.resynth." + key), (Object[])params));
    }

    static ITextComponent getTooltip(String key, TextFormatting color) {
        return ResynthItem.stringToTextComponent(color + I18n.func_135052_a((String)("tooltip.item.resynth." + key), (Object[])new Object[0]));
    }

    static ITextComponent getTooltip(ResynthItem item) {
        if (item.getRegistryName() == null) {
            return ResynthItem.stringToTextComponent(TextFormatting.RED + "Error");
        }
        return ResynthItem.getTooltip(item.getRegistryName().toString().replace(":", "."));
    }

    static void setDescriptiveTooltip(List<ITextComponent> tooltip, ResynthItem item) {
        if (!ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class).areTooltipsEnabled()) {
            return;
        }
        if (item.getRegistryName() == null) {
            tooltip.add(ResynthItem.stringToTextComponent(TextFormatting.RED + "Error"));
        }
        tooltip.add(ResynthItem.stringToTextComponent(TextFormatting.GRAY + I18n.func_135052_a((String)("tooltip.item." + item.getRegistryName().toString().replace(":", ".")), (Object[])new Object[0])));
    }

    protected static void setDescriptiveTooltip(List<ITextComponent> tooltip, String item, Object ... params) {
        if (!ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class).areTooltipsEnabled()) {
            return;
        }
        if (item == null) {
            tooltip.add(ResynthItem.stringToTextComponent(TextFormatting.RED + "Error"));
        }
        tooltip.add(ResynthItem.stringToTextComponent(TextFormatting.GRAY + I18n.func_135052_a((String)("tooltip.item.resynth." + item), (Object[])params)));
    }
}

