/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.block;

import com.ki11erwolf.resynth.plant.block.BlockPlant;
import com.ki11erwolf.resynth.plant.set.IBiochemicalSetProperties;
import com.ki11erwolf.resynth.util.MinecraftUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class BlockBiochemicalPlant
extends BlockPlant<BlockBiochemicalPlant> {
    public BlockBiochemicalPlant(String plantTypeName, String plantName, IBiochemicalSetProperties properties) {
        super(plantTypeName, plantName, properties);
    }

    @Override
    IntegerProperty getGrowthProperty() {
        return IntegerProperty.func_177719_a((String)"growth_stage", (int)0, (int)7);
    }

    @Override
    VoxelShape[] getShapeByAge() {
        return new VoxelShape[]{Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)2.0, (double)9.0), Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)2.0, (double)9.0), Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.5, (double)3.0, (double)13.0, (double)9.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0)};
    }

    @Override
    int getMaxGrowthStage() {
        return 7;
    }

    @Override
    boolean dropsProduceWhenGrown() {
        return true;
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int growth = (Integer)world.func_180495_p(pos).func_177229_b((IProperty)this.getGrowthProperty());
        int postHarvestGrowth = growth - 4;
        if (growth >= ((BlockPlant)world.func_180495_p(pos).func_177230_c()).getMaxGrowthStage() && world.func_180501_a(pos, (IBlockState)world.func_180495_p(pos).func_206870_a((IProperty)this.getGrowthProperty(), (Comparable)Integer.valueOf(postHarvestGrowth)), 2)) {
            if (!world.field_72995_K) {
                MinecraftUtil.spawnItemStackInWorld(new ItemStack((IItemProvider)this.getProduce().func_77973_b(), ((IBiochemicalSetProperties)this.properties).numberOfProduceDrops()), world, pos);
            }
            BlockBiochemicalPlant.playPopSound(world, player);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void playPopSound(World world, EntityPlayer player) {
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, 0.4f / (new Random().nextFloat() * 0.4f + 0.8f));
    }

    @Override
    void growPlant(World world, IBlockState state, BlockPos pos, int increase) {
        int growth = increase + this.getGrowthStage(state);
        if (growth > this.getMaxGrowthStage()) {
            growth = this.getMaxGrowthStage();
        }
        world.func_180501_a(pos, (IBlockState)this.func_176223_P().func_206870_a((IProperty)this.getGrowthProperty(), (Comparable)Integer.valueOf(growth)), 2);
    }
}

