/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.block;

import com.ki11erwolf.resynth.plant.block.BlockPlant;
import com.ki11erwolf.resynth.plant.set.PlantSetProperties;
import com.ki11erwolf.resynth.util.MathUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.World;

public abstract class BlockMetallicPlant
extends BlockPlant<BlockMetallicPlant> {
    private static final DirectionProperty FACING = BlockHorizontal.field_185512_D;

    public BlockMetallicPlant(String plantTypeName, String plantName, PlantSetProperties properties) {
        super(plantTypeName, plantName, properties);
    }

    @Override
    IntegerProperty getGrowthProperty() {
        return IntegerProperty.func_177719_a((String)"growth_stage", (int)0, (int)8);
    }

    @Override
    VoxelShape[] getShapeByAge() {
        return new VoxelShape[]{Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0)};
    }

    @Override
    int getMaxGrowthStage() {
        return 8;
    }

    @Override
    boolean dropsProduceWhenGrown() {
        return false;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{FACING});
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (blockIn == Block.func_149634_a((Item)this.getProduce().func_77973_b()) && ((Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)this.getGrowthProperty())).intValue() == this.getMaxGrowthStage()) {
            worldIn.func_175656_a(pos, (IBlockState)this.func_176223_P().func_206870_a((IProperty)this.getGrowthProperty(), (Comparable)Integer.valueOf(this.getMaxGrowthStage() - 1)));
        }
    }

    @Override
    void growPlant(World world, IBlockState state, BlockPos pos, int increase) {
        int growth = increase + this.getGrowthStage(state);
        if (growth >= this.getMaxGrowthStage()) {
            growth = this.getMaxGrowthStage();
            EnumFacing facing = this.placeProduce(world, pos);
            if (facing != null) {
                world.func_180501_a(pos, (IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)this.getGrowthProperty(), (Comparable)Integer.valueOf(growth))).func_206870_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing), 2);
            }
        } else {
            world.func_180501_a(pos, (IBlockState)this.func_176223_P().func_206870_a((IProperty)this.getGrowthProperty(), (Comparable)Integer.valueOf(growth)), 2);
        }
    }

    @Nullable
    private EnumFacing placeProduce(World world, BlockPos pos) {
        int random = MathUtil.getRandomIntegerInRange(0, 4);
        for (int i = 0; i < 4; ++i) {
            BlockPos pos1 = null;
            IBlockState block = null;
            EnumFacing facing = null;
            if (random > 3) {
                random = 0;
            }
            switch (random) {
                case 0: {
                    pos1 = pos.func_177978_c();
                    facing = EnumFacing.NORTH;
                    block = world.func_180495_p(pos1);
                    break;
                }
                case 1: {
                    pos1 = pos.func_177968_d();
                    facing = EnumFacing.SOUTH;
                    block = world.func_180495_p(pos1);
                    break;
                }
                case 2: {
                    pos1 = pos.func_177974_f();
                    facing = EnumFacing.EAST;
                    block = world.func_180495_p(pos1);
                    break;
                }
                case 3: {
                    pos1 = pos.func_177976_e();
                    facing = EnumFacing.WEST;
                    block = world.func_180495_p(pos1);
                }
            }
            if (block == null) {
                return null;
            }
            if (block.func_177230_c() == Blocks.field_150350_a && world.func_180495_p(pos1.func_177977_b()).func_185917_h()) {
                if (world.func_175656_a(pos1, Block.func_149634_a((Item)this.getProduce().func_77973_b()).func_176223_P())) {
                    return facing;
                }
                return null;
            }
            ++random;
        }
        return null;
    }
}

