/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.block;

import com.ki11erwolf.resynth.block.ResynthBlock;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.block.tileEntity.TileEntityMineralSoil;
import com.ki11erwolf.resynth.item.ItemMineralHoe;
import com.ki11erwolf.resynth.plant.item.ItemSeeds;
import com.ki11erwolf.resynth.plant.set.PlantSetProperties;
import com.ki11erwolf.resynth.util.MathUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Particles;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public abstract class BlockPlant<T extends BlockPlant<T>>
extends ResynthBlock<T>
implements IPlantable,
IGrowable,
ItemMineralHoe.InfoProvider {
    private static final String PLANT_PREFIX = "plant";
    final PlantSetProperties properties;

    BlockPlant(String plantTypeName, String plantName, PlantSetProperties properties) {
        super(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_185850_c).func_200944_c().func_200943_b(0.0f), plantTypeName + "_" + PLANT_PREFIX + "_" + plantName);
        this.properties = properties;
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)this.getGrowthProperty(), (Comparable)Integer.valueOf(0)));
    }

    private boolean isValidGround(IBlockState state) {
        return state.func_177230_c() == ResynthBlocks.BLOCK_MINERAL_SOIL;
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        return (worldIn.func_201669_a(pos, 0) >= 8 || worldIn.func_175678_i(pos)) && this.isValidGround(worldIn.func_180495_p(pos.func_177977_b()));
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReaderBase)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_200011_d(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return this.getShapeByAge()[(Integer)state.func_177229_b((IProperty)this.getGrowthProperty())];
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (MathUtil.chance(5.0f)) {
            BlockPlant.spawnParticles(worldIn, pos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void spawnParticles(World worldIn, BlockPos pos) {
        Random random = worldIn.field_73012_v;
        double d = random.nextGaussian() * 0.02;
        int amount = 1;
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_185904_a() != Material.field_151579_a) {
            for (int i = 0; i < amount; ++i) {
                worldIn.func_195594_a((IParticleData)Particles.field_197624_q, (double)((float)pos.func_177958_n() + random.nextFloat()), (double)pos.func_177956_o() + (double)random.nextFloat() * iblockstate.func_196954_c((IBlockReader)worldIn, pos).func_197758_c(EnumFacing.Axis.Y), (double)((float)pos.func_177952_p() + random.nextFloat()), d, d, d);
            }
        } else {
            for (int i1 = 0; i1 < amount; ++i1) {
                worldIn.func_195594_a((IParticleData)Particles.field_197624_q, (double)((float)pos.func_177958_n() + random.nextFloat()), (double)pos.func_177956_o() + (double)random.nextFloat() * 1.0, (double)((float)pos.func_177952_p() + random.nextFloat()), d, d, d);
            }
        }
    }

    private boolean isFullyGrown(IBlockState state) {
        return this.getGrowthStage(state) >= this.getMaxGrowthStage();
    }

    private int getBonemealIncrease() {
        return MathUtil.getRandomIntegerInRange(1, 3);
    }

    private float getMineralPercent(World world, BlockPos pos) {
        TileEntityMineralSoil te = null;
        if (world.func_175625_s(pos.func_177977_b()) instanceof TileEntityMineralSoil) {
            te = (TileEntityMineralSoil)world.func_175625_s(pos.func_177977_b());
        }
        if (te == null) {
            return 0.0f;
        }
        return te.getMineralPercentage();
    }

    private float getPlantGrowthChance() {
        return this.properties.chanceToGrow();
    }

    int getGrowthStage(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getGrowthProperty());
    }

    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        super.func_196267_b(state, worldIn, pos, random);
        if (!worldIn.func_205050_e(pos, 1)) {
            return;
        }
        if (worldIn.func_201669_a(pos.func_177984_a(), 0) < 9) {
            return;
        }
        if (MathUtil.chance(this.getMineralPercent(worldIn, pos)) && MathUtil.chance(this.getPlantGrowthChance())) {
            this.callGrowPlant(worldIn, state, pos, 1);
        }
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        drops.add((Object)new ItemStack((IItemProvider)this.getSeedsItem(), 1));
        if (this.getGrowthStage(state) == this.getMaxGrowthStage() && this.dropsProduceWhenGrown() && this.getProduce() != null) {
            drops.add((Object)this.getProduce());
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((IItemProvider)this.getSeedsItem());
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{this.getGrowthProperty()});
    }

    public IBlockState getPlant(IBlockReader world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return this.properties.canBonemeal() && !this.isFullyGrown(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return this.properties.canBonemeal();
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.callGrowPlant(worldIn, state, pos, this.getBonemealIncrease());
    }

    @Override
    public String getInfo(World world, BlockPos pos) {
        return I18n.func_135052_a((String)"misc.resynth.growth_stage", (Object[])new Object[]{this.getGrowthStage(world.func_180495_p(pos)) + 1 + "/" + (this.getMaxGrowthStage() + 1)});
    }

    abstract IntegerProperty getGrowthProperty();

    abstract VoxelShape[] getShapeByAge();

    abstract int getMaxGrowthStage();

    abstract boolean dropsProduceWhenGrown();

    abstract void growPlant(World var1, IBlockState var2, BlockPos var3, int var4);

    private void callGrowPlant(World world, IBlockState state, BlockPos pos, int increase) {
        if (((BlockPlant)world.func_180495_p(pos).func_177230_c()).getGrowthStage(world.func_180495_p(pos)) >= ((BlockPlant)world.func_180495_p(pos).func_177230_c()).getMaxGrowthStage()) {
            return;
        }
        ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (boolean)false);
        this.growPlant(world, state, pos, increase);
        ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state);
    }

    protected abstract ItemSeeds getSeedsItem();

    protected abstract ItemStack getProduce();
}

