/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.plant.block.BlockBiochemicalPlant;
import com.ki11erwolf.resynth.plant.item.ItemBulb;
import com.ki11erwolf.resynth.plant.item.ItemSeeds;
import com.ki11erwolf.resynth.plant.set.IBiochemicalSetProperties;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.PlantSetSeedHooks;
import com.ki11erwolf.resynth.plant.set.PublicPlantSetRegistry;
import com.ki11erwolf.resynth.util.ItemOrBlock;
import com.ki11erwolf.resynth.util.MathUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

abstract class BiochemicalSet
extends PlantSet<BlockBiochemicalPlant> {
    private static final String SET_TYPE_NAME = "biochemical";
    private static final SeedHooks SEED_HOOKS = new SeedHooks();
    private final IBiochemicalSetProperties setProperties;

    BiochemicalSet(String setName, final IBiochemicalSetProperties properties) {
        super(SET_TYPE_NAME, setName, SEED_HOOKS, properties);
        this.setProperties = properties;
        this.produceItemOrBlock = new ItemOrBlock(new ItemBulb(SET_TYPE_NAME, setName, properties));
        this.plantBlock = new BlockBiochemicalPlant(SET_TYPE_NAME, setName, this.setProperties){

            @Override
            protected ItemSeeds getSeedsItem() {
                return BiochemicalSet.this.seedsItem;
            }

            @Override
            protected ItemStack getProduce() {
                return new ItemStack((IItemProvider)BiochemicalSet.this.produceItemOrBlock.getItem(), properties.numberOfProduceDrops());
            }
        };
        this.seedsItem = new ItemSeeds(SET_TYPE_NAME, setName, this.plantBlock, properties);
    }

    abstract EntityType[] getSourceMobs();

    private static class SeedHooks
    extends PlantSetSeedHooks {
        private SeedHooks() {
        }

        @SubscribeEvent
        public void onEntityKilled(LivingDeathEvent event) {
            for (PlantSet set : PublicPlantSetRegistry.getSets(PublicPlantSetRegistry.SetType.BIOCHEMICAL)) {
                BiochemicalSet plantSet = (BiochemicalSet)set;
                for (EntityType entity : plantSet.getSourceMobs()) {
                    if (entity.func_201760_c() != event.getEntity().getClass() || !MathUtil.chance(plantSet.setProperties.seedSpawnChanceFromMob()) || event.getEntity().func_130014_f_().field_72995_K) continue;
                    event.getEntity().func_130014_f_().func_72838_d((Entity)new EntityItem(event.getEntity().func_130014_f_(), event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, new ItemStack((IItemProvider)set.getSeedsItem())));
                }
            }
        }

        @SubscribeEvent
        public void onItemDestroyed(PlayerDestroyItemEvent event) {
            for (PlantSet set : PublicPlantSetRegistry.getSets(PublicPlantSetRegistry.SetType.BIOCHEMICAL)) {
                BiochemicalSet plantSet = (BiochemicalSet)set;
                if (event.getOriginal().func_77973_b() != plantSet.getProduceItemOrBlock().getItem() || !MathUtil.chance(plantSet.setProperties.seedSpawnChanceFromBulb()) || event.getEntity().func_130014_f_().field_72995_K) continue;
                event.getEntity().func_130014_f_().func_72838_d((Entity)new EntityItem(event.getEntity().func_130014_f_(), event.getEntity().field_70165_t + (double)(MathUtil.chance(50.0f) ? MathUtil.getRandomIntegerInRange(1, 2) : -MathUtil.getRandomIntegerInRange(1, 2)), event.getEntity().field_70163_u + 2.0, event.getEntity().field_70161_v + (double)(MathUtil.chance(50.0f) ? MathUtil.getRandomIntegerInRange(1, 2) : -MathUtil.getRandomIntegerInRange(1, 2)), new ItemStack((IItemProvider)plantSet.getSeedsItem())));
            }
        }
    }
}

