/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.plant.block.BlockCrystallinePlant;
import com.ki11erwolf.resynth.plant.item.ItemSeeds;
import com.ki11erwolf.resynth.plant.item.ItemShard;
import com.ki11erwolf.resynth.plant.set.ICrystallineSetProperties;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.PlantSetSeedHooks;
import com.ki11erwolf.resynth.plant.set.PublicPlantSetRegistry;
import com.ki11erwolf.resynth.util.ItemOrBlock;
import com.ki11erwolf.resynth.util.MathUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

abstract class CrystallineSet
extends PlantSet<BlockCrystallinePlant> {
    private static final String SET_TYPE_NAME = "crystalline";
    private static final SeedHooks SEED_HOOKS = new SeedHooks();
    private final ICrystallineSetProperties setProperties;

    CrystallineSet(String setName, final ICrystallineSetProperties properties) {
        super(SET_TYPE_NAME, setName, SEED_HOOKS, properties);
        this.setProperties = properties;
        this.produceItemOrBlock = new ItemOrBlock(new ItemShard(SET_TYPE_NAME, setName, properties));
        this.plantBlock = new BlockCrystallinePlant(SET_TYPE_NAME, setName, properties){

            @Override
            protected ItemSeeds getSeedsItem() {
                return CrystallineSet.this.seedsItem;
            }

            @Override
            protected ItemStack getProduce() {
                return new ItemStack((IItemProvider)CrystallineSet.this.produceItemOrBlock.getItem(), properties.numberOfProduceDrops());
            }
        };
        this.seedsItem = new ItemSeeds(SET_TYPE_NAME, setName, this.plantBlock, properties);
    }

    abstract ItemStack getSourceOre();

    private static class SeedHooks
    extends PlantSetSeedHooks {
        private SeedHooks() {
        }

        @SubscribeEvent
        public void onBlockBroken(BlockEvent.BreakEvent event) {
            if (event.getPlayer() == null || event.getPlayer().func_184812_l_()) {
                return;
            }
            Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
            IWorld world = event.getWorld();
            double x = event.getPos().func_177958_n();
            double y = event.getPos().func_177956_o();
            double z = event.getPos().func_177952_p();
            for (PlantSet set : PublicPlantSetRegistry.getSets(PublicPlantSetRegistry.SetType.CRYSTALLINE)) {
                CrystallineSet crystallineSet = (CrystallineSet)set;
                float spawnChance = crystallineSet.setProperties.seedSpawnChanceFromOre();
                if (spawnChance < 0.0f || block != Block.func_149634_a((Item)crystallineSet.getSourceOre().func_77973_b()) || !MathUtil.chance(spawnChance)) continue;
                world.func_72838_d((Entity)new EntityItem(world.func_201672_e(), x, y, z, new ItemStack((IItemProvider)crystallineSet.seedsItem, 1)));
                event.setCanceled(true);
                world.func_180501_a(event.getPos(), Blocks.field_150350_a.func_176223_P(), 2);
            }
        }

        @SubscribeEvent
        public void onItemExpire(ItemExpireEvent event) {
            Item i = event.getEntityItem().func_92059_d().func_77973_b();
            World world = event.getEntityItem().field_70170_p;
            BlockPos pos = event.getEntityItem().func_180425_c();
            int count = event.getEntityItem().func_92059_d().func_190916_E();
            Block b = world.func_180495_p(pos).func_177230_c();
            if (b != Blocks.field_150355_j) {
                return;
            }
            for (PlantSet set : PublicPlantSetRegistry.getSets(PublicPlantSetRegistry.SetType.CRYSTALLINE)) {
                float spawnChance;
                if (i != set.getProduceItemOrBlock().getItem() || (spawnChance = ((CrystallineSet)set).setProperties.seedSpawnChanceFromShard()) < 0.0f) continue;
                for (int j = 0; j < count; ++j) {
                    if (!MathUtil.chance(spawnChance)) continue;
                    event.getEntityItem().field_70170_p.func_72838_d((Entity)new EntityItem(event.getEntityItem().field_70170_p, event.getEntityItem().field_70165_t, event.getEntityItem().field_70163_u, event.getEntityItem().field_70161_v, new ItemStack((IItemProvider)set.getSeedsItem(), 1)));
                }
                return;
            }
        }
    }
}

