/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.plant.block.BlockMetallicPlant;
import com.ki11erwolf.resynth.plant.block.BlockOrganicOre;
import com.ki11erwolf.resynth.plant.item.ItemSeeds;
import com.ki11erwolf.resynth.plant.set.IMetallicSetProperties;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.PlantSetSeedHooks;
import com.ki11erwolf.resynth.plant.set.PublicPlantSetRegistry;
import com.ki11erwolf.resynth.util.ItemOrBlock;
import com.ki11erwolf.resynth.util.MathUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

abstract class MetallicSet
extends PlantSet<BlockMetallicPlant> {
    private static final String SET_TYPE_NAME = "metallic";
    private static final SeedHooks SEED_HOOKS = new SeedHooks();
    private final IMetallicSetProperties properties;

    MetallicSet(String setName, IMetallicSetProperties properties) {
        super(SET_TYPE_NAME, setName, SEED_HOOKS, properties);
        this.properties = properties;
        this.produceItemOrBlock = new ItemOrBlock(new BlockOrganicOre(SET_TYPE_NAME, setName, properties));
        this.plantBlock = new BlockMetallicPlant(SET_TYPE_NAME, setName, properties){

            @Override
            protected ItemSeeds getSeedsItem() {
                return MetallicSet.this.seedsItem;
            }

            @Override
            protected ItemStack getProduce() {
                return new ItemStack((IItemProvider)MetallicSet.this.produceItemOrBlock.getBlock(), 1);
            }
        };
        this.seedsItem = new ItemSeeds(SET_TYPE_NAME, setName, this.plantBlock, properties);
    }

    abstract ItemStack getSourceOre();

    private static class SeedHooks
    extends PlantSetSeedHooks {
        private SeedHooks() {
        }

        @SubscribeEvent
        public void onExplosion(ExplosionEvent.Detonate detonateEvent) {
            World world = detonateEvent.getWorld();
            for (BlockPos pos : detonateEvent.getAffectedBlocks()) {
                IBlockState block = world.func_180495_p(pos);
                for (PlantSet set : PublicPlantSetRegistry.getSets(PublicPlantSetRegistry.SetType.METALLIC)) {
                    float chance = 0.0f;
                    if (block.func_177230_c() == Block.func_149634_a((Item)((MetallicSet)set).getSourceOre().func_77973_b())) {
                        chance = ((MetallicSet)set).properties.seedSpawnChanceFromOre();
                    } else if (block.func_177230_c() == set.getProduceItemOrBlock().getBlock()) {
                        chance = ((MetallicSet)set).properties.seedSpawnChanceFromOrganicOre();
                    }
                    if (!MathUtil.chance(chance)) continue;
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)set.seedsItem)));
                }
            }
        }
    }
}

