/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.BiochemicalPlantSetConfig;
import com.ki11erwolf.resynth.config.categories.CrystallinePlantSetConfig;
import com.ki11erwolf.resynth.config.categories.MetallicPlantSetConfig;
import com.ki11erwolf.resynth.plant.set.BiochemicalSet;
import com.ki11erwolf.resynth.plant.set.BiochemicalSetProperties;
import com.ki11erwolf.resynth.plant.set.CrystallineSet;
import com.ki11erwolf.resynth.plant.set.CrystallineSetProperties;
import com.ki11erwolf.resynth.plant.set.MetallicSet;
import com.ki11erwolf.resynth.plant.set.MetallicSetProperties;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class PlantSetFactory {
    private PlantSetFactory() {
    }

    public static PlantSet newVanillaCrystallineSet(String setName, CrystallineSetProperties properties, final Block sourceOre) {
        CrystallinePlantSetConfig config = ResynthConfig.VANILLA_PLANTS_CONFIG.loadCategory(new CrystallinePlantSetConfig(setName, properties));
        return new CrystallineSet(setName, config){
            private ItemStack sourceOreStack;
            {
                super(setName, properties);
                this.sourceOreStack = null;
            }

            @Override
            ItemStack getSourceOre() {
                if (this.sourceOreStack == null) {
                    this.sourceOreStack = new ItemStack((IItemProvider)sourceOre);
                }
                return this.sourceOreStack;
            }
        };
    }

    public static PlantSet newVanillaMetallicPlantSet(String setName, MetallicSetProperties properties, final Block sourceOre) {
        MetallicPlantSetConfig config = ResynthConfig.VANILLA_PLANTS_CONFIG.loadCategory(new MetallicPlantSetConfig(setName, properties));
        return new MetallicSet(setName, config){
            private ItemStack sourceOreStack;
            {
                super(setName, properties);
                this.sourceOreStack = null;
            }

            @Override
            ItemStack getSourceOre() {
                if (this.sourceOreStack == null) {
                    this.sourceOreStack = new ItemStack((IItemProvider)sourceOre);
                }
                return this.sourceOreStack;
            }
        };
    }

    public static PlantSet newVanillaBiochemicalPlantSet(String setName, BiochemicalSetProperties properties, final EntityType ... sourceMobs) {
        BiochemicalPlantSetConfig config = ResynthConfig.VANILLA_PLANTS_CONFIG.loadCategory(new BiochemicalPlantSetConfig(setName, properties));
        return new BiochemicalSet(setName, config){
            private EntityType[] sourceMobEntities;
            {
                super(setName, properties);
                this.sourceMobEntities = null;
            }

            @Override
            EntityType[] getSourceMobs() {
                if (this.sourceMobEntities == null) {
                    this.sourceMobEntities = sourceMobs;
                }
                return this.sourceMobEntities;
            }
        };
    }
}

