/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.plant.set.IBiochemicalSetProperties;
import com.ki11erwolf.resynth.plant.set.ICrystallineSetProperties;
import com.ki11erwolf.resynth.plant.set.IMetallicSetProperties;
import com.ki11erwolf.resynth.plant.set.PlantSetProperties;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class PlantSetUtil {
    private PlantSetUtil() {
    }

    private static ITextComponent getFormattedTooltip(String key, TextFormatting color, Object ... params) {
        return new TextComponentString(color + I18n.func_135052_a((String)("tooltip.property.resynth." + key), (Object[])params));
    }

    public static class PlantSetTooltipUtil {
        private PlantSetTooltipUtil() {
        }

        public static void setPropertiesTooltip(List<ITextComponent> tooltip, PlantSetProperties plantSetProperties) {
            tooltip.add(PlantSetUtil.getFormattedTooltip("growth_chance", TextFormatting.GOLD, new Object[]{Float.valueOf(plantSetProperties.chanceToGrow())}));
            tooltip.add(PlantSetUtil.getFormattedTooltip("bonemeal_enabled", TextFormatting.AQUA, new Object[]{plantSetProperties.canBonemeal()}));
            if (plantSetProperties instanceof ICrystallineSetProperties) {
                PlantSetTooltipUtil.setPropertiesTooltip(tooltip, (ICrystallineSetProperties)plantSetProperties);
            } else if (plantSetProperties instanceof IMetallicSetProperties) {
                PlantSetTooltipUtil.setPropertiesTooltip(tooltip, (IMetallicSetProperties)plantSetProperties);
            } else if (plantSetProperties instanceof IBiochemicalSetProperties) {
                PlantSetTooltipUtil.setPropertiesTooltip(tooltip, (IBiochemicalSetProperties)plantSetProperties);
            }
        }

        private static void setPropertiesTooltip(List<ITextComponent> tooltip, ICrystallineSetProperties properties) {
            tooltip.add(PlantSetUtil.getFormattedTooltip("plant_yield", TextFormatting.DARK_PURPLE, new Object[]{properties.numberOfProduceDrops()}));
            tooltip.add(PlantSetUtil.getFormattedTooltip("seed_spawn_chance_from_ore", TextFormatting.GREEN, new Object[]{Float.valueOf(properties.seedSpawnChanceFromOre())}));
            tooltip.add(PlantSetUtil.getFormattedTooltip("seed_spawn_chance_from_shard", TextFormatting.RED, new Object[]{Float.valueOf(properties.seedSpawnChanceFromShard())}));
        }

        private static void setPropertiesTooltip(List<ITextComponent> tooltip, IMetallicSetProperties properties) {
            tooltip.add(PlantSetUtil.getFormattedTooltip("seed_spawn_chance_from_ore", TextFormatting.GREEN, new Object[]{Float.valueOf(properties.seedSpawnChanceFromOre())}));
            tooltip.add(PlantSetUtil.getFormattedTooltip("seed_spawn_chance_from_organic_ore", TextFormatting.BLUE, new Object[]{Float.valueOf(properties.seedSpawnChanceFromOrganicOre())}));
        }

        private static void setPropertiesTooltip(List<ITextComponent> tooltip, IBiochemicalSetProperties properties) {
            tooltip.add(PlantSetUtil.getFormattedTooltip("plant_yield", TextFormatting.DARK_PURPLE, new Object[]{properties.numberOfProduceDrops()}));
            tooltip.add(PlantSetUtil.getFormattedTooltip("seed_spawn_chance_from_mob", TextFormatting.DARK_GREEN, new Object[]{Float.valueOf(properties.seedSpawnChanceFromMob())}));
            tooltip.add(PlantSetUtil.getFormattedTooltip("seed_spawn_chance_from_bulb", TextFormatting.YELLOW, new Object[]{Float.valueOf(properties.seedSpawnChanceFromBulb())}));
        }
    }
}

