/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.plant.set.BiochemicalSet;
import com.ki11erwolf.resynth.plant.set.CrystallineSet;
import com.ki11erwolf.resynth.plant.set.MetallicSet;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.PlantSetRegistry;
import java.util.ArrayList;
import java.util.function.Function;

public class PublicPlantSetRegistry {
    private PublicPlantSetRegistry() {
    }

    public static void foreach(SetType setType, Function<PlantSet, Void> action) {
        for (PlantSet plantSet : PlantSetRegistry.getPlantSets()) {
            if (!setType.matches(plantSet)) continue;
            action.apply(plantSet);
        }
    }

    public static PlantSet[] getSets(SetType setType) {
        ArrayList<PlantSet> plantSets = new ArrayList<PlantSet>();
        for (PlantSet plantSet : PlantSetRegistry.getPlantSets()) {
            if (!setType.matches(plantSet)) continue;
            plantSets.add(plantSet);
        }
        return plantSets.toArray(new PlantSet[0]);
    }

    public static enum SetType {
        BIOCHEMICAL{

            @Override
            public boolean matches(PlantSet set) {
                return set instanceof BiochemicalSet;
            }
        }
        ,
        CRYSTALLINE{

            @Override
            public boolean matches(PlantSet set) {
                return set instanceof CrystallineSet;
            }
        }
        ,
        METALLIC{

            @Override
            public boolean matches(PlantSet set) {
                return set instanceof MetallicSet;
            }
        }
        ,
        ALL{

            @Override
            public boolean matches(PlantSet set) {
                return set != null;
            }
        };


        public abstract boolean matches(PlantSet var1);
    }
}

