/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.block;

import com.ki11erwolf.resynth.block.ResynthBlock;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.SeedPodConfig;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.PublicPlantSetRegistry;
import com.ki11erwolf.resynth.util.MathUtil;
import com.ki11erwolf.resynth.util.MinecraftUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class BlockSeedPod
extends ResynthBlock<BlockSeedPod>
implements IPlantable {
    private static final SeedPodConfig CONFIG = ResynthConfig.GENERAL_CONFIG.getCategory(SeedPodConfig.class);
    private static final VoxelShape SEED_POD_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)14.0, (double)15.0, (double)14.0);

    BlockSeedPod(String name) {
        super(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_185850_c), name);
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Vec3d vec3d = state.func_191059_e(worldIn, pos);
        return SEED_POD_SHAPE.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    private boolean isValidGround(BlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        if (state.func_177230_c() == this) {
            return worldIn.func_180495_p(blockpos).canSustainPlant((IBlockReader)worldIn, blockpos, Direction.UP, (IPlantable)this);
        }
        return this.isValidGround(worldIn.func_180495_p(blockpos));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_220062_a(BlockState state, World world, BlockPos pos, ItemStack stack) {
        if (!CONFIG.areDropsEnabled()) {
            MinecraftUtil.spawnItemStackInWorld(new ItemStack((IItemProvider)this), world, pos);
            return;
        }
        PlantSet<?>[] plantSets = PublicPlantSetRegistry.getSets(PublicPlantSetRegistry.SetType.BIOCHEMICAL);
        PlantSet<?> randomSet = plantSets[MathUtil.getRandomIntegerInRange(0, plantSets.length - 1)];
        MinecraftUtil.spawnItemInWorld(randomSet.getSeedsItem(), world, pos);
    }

    @Nonnull
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this);
    }
}

