/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.block;

import com.ki11erwolf.resynth.ResynthTabs;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.GeneralConfig;
import com.ki11erwolf.resynth.item.ResynthItemBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;

public class ResynthBlock<T extends ResynthBlock<?>>
extends Block {
    private boolean isQueued = false;
    private final ResynthItemBlock itemBlock;

    public ResynthBlock(Block.Properties properties, String name) {
        this(properties, new Item.Properties().func_200916_a(ResynthTabs.TAB_RESYNTH), name);
    }

    public ResynthBlock(Block.Properties properties, Item.Properties itemProperties, String name) {
        super(properties);
        this.setRegistryName(name);
        this.itemBlock = new ResynthItemBlock(this, itemProperties);
        this.itemBlock.setRegistryName(name);
    }

    public ResynthItemBlock getItemBlock() {
        return this.itemBlock;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ResynthBlock.setDescriptiveTooltip(tooltip, this);
    }

    protected T queueRegistration() {
        if (this.isQueued) {
            throw new IllegalStateException(String.format("Block: %s already queued for registration.", ((Object)((Object)this)).getClass().getCanonicalName()));
        }
        ResynthBlocks.INSTANCE.queueForRegistration(this);
        this.isQueued = true;
        this.itemBlock.queueRegistration();
        return (T)((Object)this);
    }

    static ITextComponent stringToTextComponent(String text) {
        return new StringTextComponent(text);
    }

    static void setDescriptiveTooltip(List<ITextComponent> tooltip, ResynthBlock<?> block) {
        if (!ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class).areTooltipsEnabled()) {
            return;
        }
        if (block.getRegistryName() == null) {
            tooltip.add(ResynthBlock.stringToTextComponent(TextFormatting.RED + "Error"));
        }
        tooltip.add(ResynthBlock.stringToTextComponent(TextFormatting.GRAY + I18n.func_135052_a((String)("tooltip.block." + block.getRegistryName().toString().replace(":", ".")), (Object[])new Object[0])));
    }

    protected static void setDescriptiveTooltip(List<ITextComponent> tooltip, String block, Object ... params) {
        if (!ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class).areTooltipsEnabled()) {
            return;
        }
        if (block == null) {
            tooltip.add(ResynthBlock.stringToTextComponent(TextFormatting.RED + "Error"));
        }
        tooltip.add(ResynthBlock.stringToTextComponent(TextFormatting.GRAY + I18n.func_135052_a((String)("tooltip.block.resynth." + block), (Object[])params)));
    }

    protected void setDescriptiveTooltip(List<ITextComponent> tooltip, T block, Object ... params) {
        if (block.getRegistryName() == null) {
            return;
        }
        ResynthBlock.setDescriptiveTooltip(tooltip, block.getRegistryName().func_110623_a(), params);
    }
}

