/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.ki11erwolf.resynth.config.ConfigValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class ConfigCategory {
    private final String uniqueName;
    private final List<ConfigValue> values = new ArrayList<ConfigValue>();

    public ConfigCategory(String uniqueName) {
        this.uniqueName = Objects.requireNonNull(uniqueName.replace(' ', '-'));
    }

    void initValues(CommentedFileConfig config) {
        for (ConfigValue configValue : this.values) {
            String key = this.getValueKey(this.uniqueName, configValue.getUniqueName());
            if (config.contains(key)) {
                configValue.setValue(config.get(key));
            } else {
                configValue.setValue(configValue.getDefaultValue());
            }
            config.set(key, configValue.get());
            config.setComment(key, configValue.getComment());
        }
    }

    void registerConfigValue(ConfigValue value) {
        this.values.add(value);
    }

    private String getValueKey(String category, String name) {
        return category + "." + name;
    }
}

