/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config;

import com.ki11erwolf.resynth.config.ConfigCategory;
import com.ki11erwolf.resynth.config.ConfigValue;
import java.util.Objects;

public class StringConfigValue
implements ConfigValue {
    private final String uniqueName;
    private final String comment;
    private final String defaultValue;
    private String value;

    public StringConfigValue(String uniqueName, String comment, String defaultValue, ConfigCategory category) {
        this.uniqueName = Objects.requireNonNull(uniqueName).replace(' ', '-');
        this.comment = Objects.requireNonNull(comment);
        this.defaultValue = Objects.requireNonNull(defaultValue);
        category.registerConfigValue(this);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public String getComment() {
        return this.comment + "\n(type=string, default=" + this.defaultValue + ")";
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setValue(Object value) {
        this.value = String.valueOf(value);
    }

    @Override
    public Object get() {
        return this.getValue();
    }
}

