/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config.categories;

import com.ki11erwolf.resynth.config.BooleanConfigValue;
import com.ki11erwolf.resynth.config.ConfigCategory;
import com.ki11erwolf.resynth.config.IntegerConfigValue;

public class GenConfig
extends ConfigCategory {
    private final BooleanConfigValue generate;
    private final IntegerConfigValue size;
    private final IntegerConfigValue count;
    private final IntegerConfigValue bottomOffset;
    private final IntegerConfigValue maxHeight;
    private final IntegerConfigValue topOffset;

    GenConfig(String configName, boolean generate, int veinSize, int veinCount, int bottomOffset, int maxHeight, int topOffset) {
        super(configName + ".ore-generation");
        this.generate = new BooleanConfigValue("generate", "Allows enabling or disabling generating the ore block in the world.\nSet this to false to prevent the ore block from spawning in the world", generate, this);
        this.size = new IntegerConfigValue("vein-size", "The average size of the ore veins. Set this number\nhigher to increase the amount of ore blocks in an ore vein.", veinSize, 1, 100, this);
        this.count = new IntegerConfigValue("vein-count", "The average count/frequency of ore veins in a chunk.\nSet this number higher to increase the number of ore veins.", veinCount, 1, 100, this);
        this.bottomOffset = new IntegerConfigValue("bottom-offset", "The minimum height (Y-level) that the ore blocks will generate.", bottomOffset, 0, 255, this);
        this.maxHeight = new IntegerConfigValue("maximum-height", "The maximum height (Y-level) that the ore blocks will generate", maxHeight, 1, 255, this);
        this.topOffset = new IntegerConfigValue("top-offset", "The amount of blocks the ore block generation will be offset by on the Y-Axis.", topOffset, 0, 255, this);
    }

    public boolean shouldGenerate() {
        return this.generate.getValue();
    }

    public int getSize() {
        return this.size.getValue();
    }

    public int getCount() {
        return this.count.getValue();
    }

    public int getBottomOffset() {
        return this.bottomOffset.getValue();
    }

    public int getMaxHeight() {
        return this.maxHeight.getValue();
    }

    public int getTopOffset() {
        return this.topOffset.getValue();
    }
}

