/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.config.categories;

import com.ki11erwolf.resynth.config.BooleanConfigValue;
import com.ki11erwolf.resynth.config.ConfigCategory;
import com.ki11erwolf.resynth.config.DoubleConfigValue;
import com.ki11erwolf.resynth.plant.set.IMetallicSetProperties;
import com.ki11erwolf.resynth.plant.set.MetallicSetProperties;

public class MetallicPlantSetConfig
extends ConfigCategory
implements IMetallicSetProperties {
    private static final String PREFIX = "plant-set-";
    private final BooleanConfigValue canUseBonemeal;
    private final DoubleConfigValue chanceToGrow;
    private final DoubleConfigValue seedSpawnChanceFromOre;
    private final DoubleConfigValue seedSpawnChanceFromOrganicOre;

    public MetallicPlantSetConfig(String plantSetName, MetallicSetProperties defaultProperties) {
        super(PREFIX + plantSetName);
        this.canUseBonemeal = new BooleanConfigValue("enable-bonemeal", "Set this to true to allow using bonemeal on this specific plant type.", defaultProperties.canBonemeal(), this);
        this.chanceToGrow = new DoubleConfigValue("chance-to-grow", "The chance (percentage) this plant type will grow on a random tick.\nIncrease this number to increase the growth rate of the plant,\ndecrease it to decrease the growth rate of the plant.", defaultProperties.chanceToGrow(), 0.0, 100.0, this);
        this.seedSpawnChanceFromOre = new DoubleConfigValue("seed-spawn-chance-from-ore", "The chance (percentage) that this plant types seed will spawn\nwhen the final products ore block is blown up with TNT.\nSet this to 0 to prevent the seeds from spawning when blowing up the ore blocks.", defaultProperties.seedSpawnChanceFromOre(), 0.0, 100.0, this);
        this.seedSpawnChanceFromOrganicOre = new DoubleConfigValue("seed-spawn-chance-from-organic-ore", "The chance (percentage) that this plant types seed will spawn\nwhen the plant produce block is blown up with TNT.\nSet this to 0 to prevent the seeds from spawning when blowing\nup the plant produce blocks.", defaultProperties.seedSpawnChanceFromOrganicOre(), 0.0, 100.0, this);
    }

    @Override
    public boolean canBonemeal() {
        return this.canUseBonemeal.getValue();
    }

    @Override
    public float chanceToGrow() {
        return (float)this.chanceToGrow.getValue();
    }

    @Override
    public float seedSpawnChanceFromOre() {
        return (float)this.seedSpawnChanceFromOre.getValue();
    }

    @Override
    public float seedSpawnChanceFromOrganicOre() {
        return (float)this.seedSpawnChanceFromOrganicOre.getValue();
    }
}

