/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.block;

import com.ki11erwolf.resynth.plant.block.BlockPlant;
import com.ki11erwolf.resynth.plant.set.ICrystallineSetProperties;
import com.ki11erwolf.resynth.util.EffectsUtil;
import com.ki11erwolf.resynth.util.MinecraftUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.World;

public abstract class BlockCrystallinePlant
extends BlockPlant<BlockCrystallinePlant> {
    public BlockCrystallinePlant(String plantTypeName, String plantName, ICrystallineSetProperties properties) {
        super(plantTypeName, plantName, properties);
    }

    @Override
    IntegerProperty getGrowthProperty() {
        return IntegerProperty.func_177719_a((String)"growth_stage", (int)0, (int)7);
    }

    @Override
    VoxelShape[] getShapeByAge() {
        return new VoxelShape[]{Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.5, (double)11.0), Block.func_208617_a((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)5.0, (double)11.5), Block.func_208617_a((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)7.5, (double)13.5), Block.func_208617_a((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)7.5, (double)13.5), Block.func_208617_a((double)0.5, (double)0.5, (double)0.5, (double)15.5, (double)11.0, (double)15.5), Block.func_208617_a((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)14.0, (double)15.5), Block.func_208617_a((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)15.0, (double)15.5)};
    }

    @Override
    public int getMaxGrowthStage() {
        return 7;
    }

    @Override
    boolean dropsProduceWhenGrown() {
        return true;
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        int growth = (Integer)world.func_180495_p(pos).func_177229_b((IProperty)this.getGrowthProperty());
        int postHarvestGrowth = 0;
        if (growth >= ((BlockPlant)world.func_180495_p(pos).func_177230_c()).getMaxGrowthStage() && world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((IProperty)this.getGrowthProperty(), (Comparable)Integer.valueOf(postHarvestGrowth)), 2)) {
            if (!world.field_72995_K) {
                MinecraftUtil.spawnItemStackInWorld(new ItemStack((IItemProvider)this.getProduce().func_77973_b(), ((ICrystallineSetProperties)this.properties).numberOfProduceDrops()), world, pos);
            }
            EffectsUtil.playNormalSoundWithRandomPitch(world, player, pos, SoundEvents.field_219626_bz, SoundCategory.BLOCKS);
            return true;
        }
        return false;
    }

    @Override
    void growPlant(World world, BlockState state, BlockPos pos, int increase) {
        int growth = increase + this.getGrowthStage(state);
        if (growth > this.getMaxGrowthStage()) {
            growth = this.getMaxGrowthStage();
        }
        world.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a((IProperty)this.getGrowthProperty(), (Comparable)Integer.valueOf(growth)), 2);
    }
}

