/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.block;

import com.ki11erwolf.resynth.block.BlockEnhancer;
import com.ki11erwolf.resynth.block.ResynthBlock;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.block.tileEntity.TileEntityMineralSoil;
import com.ki11erwolf.resynth.plant.item.ItemSeeds;
import com.ki11erwolf.resynth.plant.set.PlantSetProperties;
import com.ki11erwolf.resynth.util.EffectsUtil;
import com.ki11erwolf.resynth.util.MathUtil;
import com.ki11erwolf.resynth.util.MinecraftUtil;
import com.ki11erwolf.resynth.util.PlantPatchInfoProvider;
import java.util.List;
import java.util.Random;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public abstract class BlockPlant<T extends BlockPlant<T>>
extends ResynthBlock<T>
implements IPlantable,
IGrowable,
IComponentProvider,
PlantPatchInfoProvider {
    private static final String PLANT_PREFIX = "plant";
    final PlantSetProperties properties;

    BlockPlant(String plantTypeName, String plantName, PlantSetProperties properties) {
        super(Block.Properties.func_200945_a((Material)Material.field_151585_k).func_200947_a(SoundType.field_185850_c).func_200944_c().func_200943_b(0.0f), plantTypeName + "_" + PLANT_PREFIX + "_" + plantName);
        this.properties = properties;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)this.getGrowthProperty(), (Comparable)Integer.valueOf(0)));
    }

    private boolean isValidGround(BlockState state) {
        return state.func_177230_c() == ResynthBlocks.BLOCK_MINERAL_SOIL;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return (worldIn.func_201669_a(pos, 0) >= 8 || worldIn.func_175710_j(pos)) && this.isValidGround(worldIn.func_180495_p(pos.func_177977_b()));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShapeByAge()[(Integer)state.func_177229_b((IProperty)this.getGrowthProperty())];
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EffectsUtil.displayStandardEffectsWithChance(worldIn, pos, 1, 5.0f, (IParticleData)ParticleTypes.field_197624_q);
    }

    private boolean isFullyGrown(BlockState state) {
        return this.getGrowthStage(state) >= this.getMaxGrowthStage();
    }

    private int getBonemealIncrease() {
        return MathUtil.getRandomIntegerInRange(1, 3);
    }

    private float getMineralPercent(World world, BlockPos pos) {
        TileEntityMineralSoil te = null;
        if (world.func_175625_s(pos.func_177977_b()) instanceof TileEntityMineralSoil) {
            te = (TileEntityMineralSoil)world.func_175625_s(pos.func_177977_b());
        }
        if (te == null) {
            return 0.0f;
        }
        return te.getMineralPercentage();
    }

    private float getMineralPercentIncrease(World world, BlockPos pos) {
        BlockState enhancer = world.func_180495_p(pos.func_177977_b().func_177977_b());
        if (enhancer.func_177230_c() instanceof BlockEnhancer) {
            return ((BlockEnhancer)enhancer.func_177230_c()).getIncrease();
        }
        return 0.0f;
    }

    private float getPlantGrowthChance() {
        return this.properties.chanceToGrow();
    }

    public int getGrowthStage(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getGrowthProperty());
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        super.func_196267_b(state, worldIn, pos, random);
        if (this.canGrow(worldIn, pos)) {
            this.callGrowPlant(worldIn, state, pos, 1);
        }
    }

    private boolean canGrow(World world, BlockPos pos) {
        if (!world.isAreaLoaded(pos, 1)) {
            return false;
        }
        if (world.func_201669_a(pos.func_177984_a(), 0) < 9) {
            return false;
        }
        float mineralPercentChance = this.getMineralPercent(world, pos);
        float mineralPercentIncrease = this.getMineralPercentIncrease(world, pos);
        float combined = mineralPercentChance + ((double)mineralPercentChance > 49.9 ? mineralPercentIncrease : 0.0f);
        return MathUtil.chance(combined) && MathUtil.chance(this.getPlantGrowthChance());
    }

    public void func_220062_a(BlockState state, World worldIn, BlockPos pos, ItemStack stack) {
        MinecraftUtil.spawnItemInWorld(this.getSeedsItem(), worldIn, pos);
        if (this.getGrowthStage(state) == this.getMaxGrowthStage() && this.dropsProduceWhenGrown() && this.getProduce() != null) {
            MinecraftUtil.spawnItemStackInWorld(this.getProduce(), worldIn, pos);
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.getSeedsItem());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{this.getGrowthProperty()});
    }

    public BlockState getPlant(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return this.properties.canBonemeal() && !this.isFullyGrown(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return this.properties.canBonemeal();
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, BlockState state) {
        this.callGrowPlant(worldIn, state, pos, this.getBonemealIncrease());
    }

    @Override
    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (tooltip.isEmpty()) {
            tooltip.add((ITextComponent)new StringTextComponent(BlockPlant.getGrowthStageMessage(this.getGrowthStage(accessor.getWorld().func_180495_p(accessor.getPosition())), this.getMaxGrowthStage())));
        }
    }

    public PlantSetProperties getProperties() {
        return this.properties;
    }

    private static String getGrowthStageMessage(int growthStage, int max) {
        return TextFormatting.GREEN + I18n.func_135052_a((String)"misc.resynth.growth_stage", (Object[])new Object[]{TextFormatting.GOLD + (growthStage + 1) + "/" + (max + 1)});
    }

    abstract IntegerProperty getGrowthProperty();

    abstract VoxelShape[] getShapeByAge();

    public abstract int getMaxGrowthStage();

    abstract boolean dropsProduceWhenGrown();

    abstract void growPlant(World var1, BlockState var2, BlockPos var3, int var4);

    private void callGrowPlant(World world, BlockState state, BlockPos pos, int increase) {
        if (((BlockPlant)world.func_180495_p(pos).func_177230_c()).getGrowthStage(world.func_180495_p(pos)) >= ((BlockPlant)world.func_180495_p(pos).func_177230_c()).getMaxGrowthStage()) {
            return;
        }
        ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (BlockState)state, (boolean)false);
        this.growPlant(world, state, pos, increase);
        ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
    }

    protected abstract ItemSeeds getSeedsItem();

    protected abstract ItemStack getProduce();
}

