/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.analytics.PlantSetFailureEvent;
import com.ki11erwolf.resynth.analytics.ResynthAnalytics;
import com.ki11erwolf.resynth.plant.block.BlockPlant;
import com.ki11erwolf.resynth.plant.item.ItemSeeds;
import com.ki11erwolf.resynth.plant.set.PlantSetProperties;
import com.ki11erwolf.resynth.plant.set.PlantSetRegistry;
import com.ki11erwolf.resynth.plant.set.PlantSetSeedHooks;
import com.ki11erwolf.resynth.util.ItemOrBlock;
import java.util.Objects;

public class PlantSet<P extends BlockPlant<?>> {
    private final String setName;
    private final String setTypeName;
    private final PlantSetProperties basicPlantSetProperties;
    private boolean isFailure;
    P plantBlock;
    ItemSeeds seedsItem;
    ItemOrBlock produceItemOrBlock;

    PlantSet(String setTypeName, String setName, PlantSetSeedHooks seedHooks, PlantSetProperties properties) {
        this.setTypeName = Objects.requireNonNull(setTypeName);
        this.setName = Objects.requireNonNull(setName);
        this.basicPlantSetProperties = properties;
        seedHooks.register();
    }

    void flagAsFailure() {
        if (this.isFailure) {
            return;
        }
        this.getSeedsItem().flagAsFailure();
        ResynthAnalytics.send(new PlantSetFailureEvent(this.setName));
    }

    boolean isFailure() {
        return this.isFailure;
    }

    public String getSetTypeName() {
        return this.setTypeName;
    }

    public String getSetName() {
        return this.setName;
    }

    public P getPlantBlock() {
        return this.plantBlock;
    }

    public ItemOrBlock getProduceItemOrBlock() {
        return this.produceItemOrBlock;
    }

    public ItemSeeds getSeedsItem() {
        return this.seedsItem;
    }

    public PlantSetProperties getPlantSetProperties() {
        return this.basicPlantSetProperties;
    }

    public PlantSet<P> register() {
        PlantSetRegistry.registerPlantSet(this);
        return this;
    }
}

