/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.BiochemicalPlantSetConfig;
import com.ki11erwolf.resynth.config.categories.CrystallinePlantSetConfig;
import com.ki11erwolf.resynth.config.categories.MetallicPlantSetConfig;
import com.ki11erwolf.resynth.plant.set.BiochemicalSet;
import com.ki11erwolf.resynth.plant.set.BiochemicalSetProperties;
import com.ki11erwolf.resynth.plant.set.CrystallineSet;
import com.ki11erwolf.resynth.plant.set.CrystallineSetProperties;
import com.ki11erwolf.resynth.plant.set.MetallicSet;
import com.ki11erwolf.resynth.plant.set.MetallicSetProperties;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public class PlantSetFactory {
    private static final Logger LOG = ResynthMod.getNewLogger();

    private PlantSetFactory() {
    }

    public static PlantSet<?> newVanillaCrystallineSet(String setName, CrystallineSetProperties properties, final Block sourceOre) {
        CrystallinePlantSetConfig config = ResynthConfig.VANILLA_PLANTS_CONFIG.loadCategory(new CrystallinePlantSetConfig(setName, properties));
        return new CrystallineSet(setName, config){
            private ItemStack sourceOreStack;
            {
                super(setName, properties);
                this.sourceOreStack = null;
            }

            @Override
            ItemStack getSourceOre() {
                if (this.sourceOreStack == null) {
                    this.sourceOreStack = new ItemStack((IItemProvider)sourceOre);
                }
                return this.sourceOreStack;
            }
        };
    }

    public static PlantSet<?> newModdedCrystallineSet(String modid, String setName, CrystallineSetProperties properties, String sourceOreRegistryName) {
        final ResourceLocation sourceOreRL = new ResourceLocation(modid, sourceOreRegistryName);
        LOG.info("Attempting to create modded crystalline plant set: " + modid + ":" + setName);
        if (!ModList.get().isLoaded(modid)) {
            LOG.info("Mod: " + modid + " is not present! Skipping plant set: " + setName);
            return null;
        }
        LOG.info("Mod: " + modid + " is present! Continuing...");
        CrystallinePlantSetConfig config = ResynthConfig.MODDED_PLANTS_CONFIG.loadCategory(new CrystallinePlantSetConfig(modid + "-" + setName, properties));
        return new CrystallineSet(modid + "_" + setName, config){
            private ItemStack sourceOreStack;
            {
                super(setName, properties);
                this.sourceOreStack = null;
            }

            @Override
            ItemStack getSourceOre() {
                if (this.sourceOreStack != null) {
                    return this.sourceOreStack;
                }
                Block sourceOre = (Block)ForgeRegistries.BLOCKS.getValue(sourceOreRL);
                if (!ForgeRegistries.BLOCKS.containsKey(sourceOreRL) || sourceOre == null || sourceOre == Blocks.field_150350_a) {
                    LOG.error("Failed to get source ore: " + sourceOreRL.toString());
                    this.flagAsFailure();
                } else {
                    LOG.info("Found source ore: " + sourceOreRL.toString());
                    this.sourceOreStack = new ItemStack((IItemProvider)sourceOre);
                }
                return this.sourceOreStack;
            }
        };
    }

    public static PlantSet<?> newVanillaMetallicPlantSet(String setName, MetallicSetProperties properties, final Block sourceOre) {
        MetallicPlantSetConfig config = ResynthConfig.VANILLA_PLANTS_CONFIG.loadCategory(new MetallicPlantSetConfig(setName, properties));
        return new MetallicSet(setName, config){
            private ItemStack sourceOreStack;
            {
                super(setName, properties);
                this.sourceOreStack = null;
            }

            @Override
            ItemStack getSourceOre() {
                if (this.sourceOreStack == null) {
                    this.sourceOreStack = new ItemStack((IItemProvider)sourceOre);
                }
                return this.sourceOreStack;
            }
        };
    }

    public static PlantSet<?> newModdedMetallicSet(String modid, String setName, MetallicSetProperties properties, String sourceOreRegistryName) {
        final ResourceLocation sourceOreRL = new ResourceLocation(modid, sourceOreRegistryName);
        LOG.info("Attempting to create modded Metallic plant set: " + modid + ":" + setName);
        if (!ModList.get().isLoaded(modid)) {
            LOG.info("Mod: " + modid + " is not present! Skipping plant set: " + setName);
            return null;
        }
        LOG.info("Mod: " + modid + " is present! Continuing...");
        MetallicPlantSetConfig config = ResynthConfig.MODDED_PLANTS_CONFIG.loadCategory(new MetallicPlantSetConfig(modid + "-" + setName, properties));
        return new MetallicSet(modid + "_" + setName, config){
            private ItemStack sourceOreStack;
            {
                super(setName, properties);
                this.sourceOreStack = null;
            }

            @Override
            ItemStack getSourceOre() {
                if (this.sourceOreStack != null) {
                    return this.sourceOreStack;
                }
                Block sourceOre = (Block)ForgeRegistries.BLOCKS.getValue(sourceOreRL);
                if (!ForgeRegistries.BLOCKS.containsKey(sourceOreRL) || sourceOre == null || sourceOre == Blocks.field_150350_a) {
                    LOG.error("Failed to get source ore: " + sourceOreRL.toString());
                    this.flagAsFailure();
                } else {
                    LOG.info("Found source ore: " + sourceOreRL.toString());
                    this.sourceOreStack = new ItemStack((IItemProvider)sourceOre);
                }
                return this.sourceOreStack;
            }
        };
    }

    public static PlantSet<?> newVanillaBiochemicalPlantSet(String setName, BiochemicalSetProperties properties, final EntityType<?> ... sourceMobs) {
        BiochemicalPlantSetConfig config = ResynthConfig.VANILLA_PLANTS_CONFIG.loadCategory(new BiochemicalPlantSetConfig(setName, properties));
        return new BiochemicalSet(setName, config){
            private EntityType<?>[] sourceMobEntities;
            {
                super(setName, properties);
                this.sourceMobEntities = null;
            }

            @Override
            EntityType<?>[] getSourceMobs() {
                if (this.sourceMobEntities == null) {
                    this.sourceMobEntities = sourceMobs;
                }
                return this.sourceMobEntities;
            }
        };
    }

    public static PlantSet<?> newModdedBiochemicalSet(final String modid, String setName, BiochemicalSetProperties properties, final String ... sourceEntityRegistryNames) {
        LOG.info("Attempting to create modded Biochemical plant set: " + modid + ":" + setName);
        if (!ModList.get().isLoaded(modid)) {
            LOG.info("Mod: " + modid + " is not present! Skipping plant set: " + setName);
            return null;
        }
        LOG.info("Mod: " + modid + " is present! Continuing...");
        BiochemicalPlantSetConfig config = ResynthConfig.MODDED_PLANTS_CONFIG.loadCategory(new BiochemicalPlantSetConfig(modid + "-" + setName, properties));
        return new BiochemicalSet(modid + "_" + setName, config){
            private List<EntityType<?>> sourceEntities;

            @Override
            EntityType<?>[] getSourceMobs() {
                if (this.sourceEntities != null) {
                    return this.sourceEntities.toArray(new EntityType[0]);
                }
                LOG.info("Looking for source entities for plant set: " + this.getSetName());
                for (String registryName : sourceEntityRegistryNames) {
                    ResourceLocation entityRL = new ResourceLocation(modid, registryName);
                    LOG.info("Looking for source entity: " + entityRL.toString());
                    EntityType entity = (EntityType)ForgeRegistries.ENTITIES.getValue(entityRL);
                    if (ForgeRegistries.ENTITIES.containsKey(entityRL) && entity != null) {
                        LOG.info("Found source entity: " + entity.func_212546_e().func_150261_e());
                        if (this.sourceEntities == null) {
                            this.sourceEntities = new ArrayList();
                        }
                        this.sourceEntities.add(entity);
                        continue;
                    }
                    LOG.error("Failed to find source entity: " + entityRL);
                }
                if (this.sourceEntities == null) {
                    LOG.error("Failed to find any source entities for plant set:" + this.getSetName());
                    this.flagAsFailure();
                }
                return null;
            }
        };
    }
}

