/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.plant.set;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.ResynthModdedPlants;
import com.ki11erwolf.resynth.ResynthPlants;
import com.ki11erwolf.resynth.block.ResynthBlock;
import com.ki11erwolf.resynth.integration.RHwylaIntegration;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.util.ItemOrBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

class PlantSetRegistry {
    private static final Logger LOG = ResynthMod.getNewLogger();
    private static final List<PlantSet<?>> PLANT_SETS = new ArrayList(45);

    PlantSetRegistry() {
    }

    static void registerPlantSet(PlantSet<?> set) {
        if (PLANT_SETS.contains(Objects.requireNonNull(set))) {
            LOG.warn("Attempt to register plant set: " + set.getSetName() + " more than once!");
            return;
        }
        LOG.info("Queuing plant set for registration: " + set.getSetName());
        PLANT_SETS.add(set);
    }

    static PlantSet<?>[] getPlantSets() {
        return PLANT_SETS.toArray(new PlantSet[0]);
    }

    @Mod.EventBusSubscriber(modid="resynth", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class Registerer {
        private Registerer() {
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            PLANT_SETS.forEach(set -> {
                Registerer.registerPlantBlock(set, (IForgeRegistry<Block>)event.getRegistry());
                Registerer.registerProduceItemOrBlock(set, event.getRegistry(), false);
            });
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            PLANT_SETS.forEach(set -> {
                Registerer.registerSeedsItem(set, (IForgeRegistry<Item>)event.getRegistry());
                Registerer.registerProduceItemOrBlock(set, event.getRegistry(), true);
            });
        }

        private static void registerPlantBlock(PlantSet<?> set, IForgeRegistry<Block> registry) {
            LOG.debug("Registering plant block: " + set.getPlantBlock().getRegistryName());
            registry.register(set.getPlantBlock());
            RHwylaIntegration.addIfProvider(set.getPlantBlock());
        }

        private static void registerPlantItemBlock(PlantSet<?> set, IForgeRegistry<Item> registry) {
            LOG.debug("Registering plant item block: " + ((ResynthBlock)((Object)set.getPlantBlock())).getItemBlock().getRegistryName());
            registry.register((IForgeRegistryEntry)((ResynthBlock)((Object)set.getPlantBlock())).getItemBlock());
        }

        private static void registerSeedsItem(PlantSet<?> set, IForgeRegistry<Item> registry) {
            LOG.debug("Registering plant seeds item: " + set.getSeedsItem().getRegistryName());
            registry.register((IForgeRegistryEntry)set.getSeedsItem());
        }

        private static void registerProduceItemOrBlock(PlantSet<?> set, IForgeRegistry registry, boolean item) {
            ItemOrBlock itemOrBlock = set.getProduceItemOrBlock();
            if (itemOrBlock.isBlock() && !item) {
                LOG.debug("Registering plant produce block: " + itemOrBlock.getBlock().getRegistryName());
                registry.register((IForgeRegistryEntry)itemOrBlock.getBlock());
                RHwylaIntegration.addIfProvider(itemOrBlock.getBlock());
            }
            if (itemOrBlock.isBlock() && item) {
                LOG.debug("Registering plant produce ItemBlock: " + itemOrBlock.getBlock().getRegistryName());
                registry.register((IForgeRegistryEntry)((ResynthBlock)itemOrBlock.getBlock()).getItemBlock());
            }
            if (itemOrBlock.isItem() && item) {
                LOG.debug("Registering plant produce item: " + itemOrBlock.getItem().getRegistryName());
                registry.register((IForgeRegistryEntry)itemOrBlock.getItem());
            }
        }

        static {
            LOG.info("Queuing plant set registration...");
            ResynthPlants.initSets();
            ResynthModdedPlants.initSets();
        }
    }
}

