/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.proxy;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.analytics.ConnectEvent;
import com.ki11erwolf.resynth.analytics.NewUserEvent;
import com.ki11erwolf.resynth.analytics.ResynthAnalytics;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.GeneralConfig;
import com.ki11erwolf.resynth.features.ResynthFeatures;
import com.ki11erwolf.resynth.proxy.Proxy;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public class ServerProxy
implements Proxy {
    private static final Logger LOG = ResynthMod.getNewLogger();

    @Override
    public void setup(FMLCommonSetupEvent event) {
        this.sendConnectEvent();
        this.printItemAndBlockRegisters();
        ResynthFeatures.init();
    }

    private void sendConnectEvent() {
        ResynthAnalytics.send(new ConnectEvent());
        File resynthFile = new File(System.getProperty("user.home") + "/" + "/resynth.id");
        if (!resynthFile.exists()) {
            ResynthAnalytics.send(new NewUserEvent());
            try {
                boolean create = resynthFile.createNewFile();
                if (!create) {
                    LOG.error("Failed to create Resynth NU file");
                }
            }
            catch (IOException e) {
                LOG.error("Failed to create Resynth NU file", (Throwable)e);
            }
        }
    }

    private void printItemAndBlockRegisters() {
        if (ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class).isDevHelpEnabled()) {
            for (Map.Entry entry : ForgeRegistries.ITEMS.getEntries()) {
                LOG.info("<Resynth-Development-Help> | Found item: " + ((ResourceLocation)entry.getKey()).func_110624_b() + ":" + ((ResourceLocation)entry.getKey()).toString());
            }
            for (Map.Entry entry : ForgeRegistries.BLOCKS.getEntries()) {
                LOG.info("<Resynth-Development-Help> | Found block: " + ((ResourceLocation)entry.getKey()).func_110624_b() + ":" + ((ResourceLocation)entry.getKey()).toString());
            }
        }
    }
}

