/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.util;

import com.ki11erwolf.resynth.util.MathUtil;
import com.ki11erwolf.resynth.util.SideUtil;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EffectsUtil {
    private EffectsUtil() {
    }

    public static boolean playNormalSound(World world, PlayerEntity player, BlockPos pos, SoundEvent soundEvent, SoundCategory category) {
        float volume = 1.0f;
        float pitch = 1.0f;
        return EffectsUtil.playNormalSound(world, player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), pos.func_177952_p(), soundEvent, category, volume, pitch);
    }

    private static boolean playNormalSoundWithPitch(World world, PlayerEntity player, BlockPos pos, SoundEvent soundEvent, SoundCategory category, float pitch) {
        float volume = 1.0f;
        return EffectsUtil.playNormalSound(world, player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), pos.func_177952_p(), soundEvent, category, volume, pitch);
    }

    public static boolean playNormalSoundWithPitchInRage(World world, PlayerEntity player, BlockPos pos, SoundEvent soundEvent, SoundCategory category, float basePitch, float pitchMultiplier) {
        float volume = 1.0f;
        float pitch = basePitch + world.func_201674_k().nextFloat() * pitchMultiplier;
        return EffectsUtil.playNormalSound(world, player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), pos.func_177952_p(), soundEvent, category, volume, pitch);
    }

    public static boolean playNormalSoundWithPitchInRage(World world, PlayerEntity player, SoundEvent soundEvent, SoundCategory category, float basePitch, float pitchMultiplier) {
        float volume = 1.0f;
        float pitch = basePitch + world.func_201674_k().nextFloat() * pitchMultiplier;
        BlockPos pos = player.func_180425_c();
        return EffectsUtil.playNormalSound(world, player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), pos.func_177952_p(), soundEvent, category, volume, pitch);
    }

    public static boolean playNormalSoundWithRandomPitch(World world, PlayerEntity player, BlockPos pos, SoundEvent soundEvent, SoundCategory category) {
        return EffectsUtil.playNormalSoundWithPitchInRage(world, player, pos, soundEvent, category, 0.8f, 0.3f);
    }

    public static boolean playNormalSoundWithVolumeOnClient(BlockPos pos, SoundEvent soundEvent, SoundCategory category, float volume) {
        return EffectsUtil.playNormalSoundOnClient(pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), soundEvent, category, volume, 1.0f, false);
    }

    public static boolean displayStandardEffectsWithChance(World world, BlockPos pos, int intensity, float chance, IParticleData particleType) {
        return EffectsUtil.displayEffectsWithChance(world, pos, intensity, 0.02, particleType, chance);
    }

    public static boolean displayStandardEffectsWithSpeed(World world, BlockPos pos, int intensity, IParticleData particleType, double speedMultiplier) {
        return EffectsUtil.displayEffects(world, pos, intensity, speedMultiplier, particleType);
    }

    public static boolean displayStandardEffects(World world, BlockPos pos, int intensity, IParticleData particleType) {
        return EffectsUtil.displayEffects(world, pos, intensity, 0.02, particleType);
    }

    public static boolean displayStandardEffectsOnClient(BlockPos pos, int intensity, IParticleData particleType) {
        return EffectsUtil.displayEffectsOnClient(pos, intensity, 0.02, particleType);
    }

    private static boolean playNormalSound(World world, double x, double y, double z, SoundEvent soundEvent, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        if (EffectsUtil.isUnsafe(world)) {
            return false;
        }
        world.func_184134_a(x, y, z, soundEvent, category, volume, pitch, distanceDelay);
        return true;
    }

    private static boolean playNormalSound(World world, PlayerEntity player, double x, double y, double z, SoundEvent soundEvent, SoundCategory category, float volume, float pitch) {
        if (EffectsUtil.isUnsafe(world)) {
            return false;
        }
        world.func_184148_a(player, x, y, z, soundEvent, category, volume, pitch);
        return true;
    }

    private static boolean playNormalSoundOnClient(PlayerEntity player, double x, double y, double z, SoundEvent soundEvent, SoundCategory category, float volume, float pitch) {
        World world = EffectsUtil.getClientWorld();
        if (world == null) {
            return false;
        }
        world.func_184148_a(player, x, y, z, soundEvent, category, volume, pitch);
        return true;
    }

    private static boolean playNormalSoundOnClient(double x, double y, double z, SoundEvent soundEvent, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        World world = EffectsUtil.getClientWorld();
        if (world == null) {
            return false;
        }
        world.func_184134_a(x, y, z, soundEvent, category, volume, pitch, distanceDelay);
        return true;
    }

    private static boolean displayEffects(World world, BlockPos pos, int intensity, double speedMultiplier, IParticleData particleType) {
        if (EffectsUtil.isUnsafe(world)) {
            return false;
        }
        Random random = world.field_73012_v;
        double d = random.nextGaussian() * speedMultiplier;
        BlockState blockstate = world.func_180495_p(pos);
        if (blockstate.func_185904_a() != Material.field_151579_a) {
            for (int i = 0; i < intensity; ++i) {
                world.func_195594_a(particleType, (double)((float)pos.func_177958_n() + random.nextFloat()), (double)pos.func_177956_o() + (double)random.nextFloat() * blockstate.func_196954_c((IBlockReader)world, pos).func_197758_c(Direction.Axis.Y), (double)((float)pos.func_177952_p() + random.nextFloat()), d, d, d);
            }
        } else {
            for (int i = 0; i < intensity; ++i) {
                world.func_195594_a(particleType, (double)((float)pos.func_177958_n() + random.nextFloat()), (double)pos.func_177956_o() + (double)random.nextFloat() * 1.0, (double)((float)pos.func_177952_p() + random.nextFloat()), d, d, d);
            }
        }
        return true;
    }

    private static boolean displayEffectsWithChance(World world, BlockPos pos, int intensity, double speedMultiplier, IParticleData particleType, float chance) {
        if (EffectsUtil.isUnsafe(world)) {
            return false;
        }
        if (MathUtil.chance(chance)) {
            EffectsUtil.displayEffects(world, pos, intensity, speedMultiplier, particleType);
        }
        return true;
    }

    private static boolean displayEffectsOnClient(BlockPos pos, int intensity, double speedMultiplier, IParticleData particleType) {
        World world = EffectsUtil.getClientWorld();
        if (world == null) {
            return false;
        }
        return EffectsUtil.displayEffects(world, pos, intensity, speedMultiplier, particleType);
    }

    private static World getClientWorld() {
        if (EffectsUtil.isClientUnsafe()) {
            return null;
        }
        World world = ClientWorldGetter.getClientWorld();
        return EffectsUtil.isUnsafe(world) ? null : world;
    }

    private static boolean isClientUnsafe() {
        return !SideUtil.isClientSafe();
    }

    private static boolean isUnsafe(World world) {
        return !SideUtil.isClientTrueSafe(world);
    }

    private static boolean isUnsafe() {
        return !SideUtil.isClientTrueSafe();
    }

    private static final class ClientWorldGetter {
        private ClientWorldGetter() {
        }

        private static World getClientWorld() {
            return Minecraft.func_71410_x().field_71441_e;
        }
    }
}

