/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.util;

import java.util.Random;

public final class MathUtil {
    private static final Random RANDOM_INSTANCE = new Random();

    private MathUtil() {
    }

    public static int getRandomIntegerInRange(int min, int max) {
        if (min >= max) {
            throw new IllegalArgumentException("Maximum integer must be greater than minimum integer");
        }
        return RANDOM_INSTANCE.nextInt(max - min + 1) + min;
    }

    public static boolean chance(float percentage) {
        if ((double)percentage >= 100.0) {
            return true;
        }
        if (percentage <= 0.0f) {
            return false;
        }
        float random = RANDOM_INSTANCE.nextFloat();
        return percentage / 100.0f > random;
    }
}

