/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth;

import com.ki11erwolf.resynth.plant.set.CrystallineSetProperties;
import com.ki11erwolf.resynth.plant.set.MetallicSetProperties;
import com.ki11erwolf.resynth.plant.set.PlantSet;
import com.ki11erwolf.resynth.plant.set.PlantSetFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class ResynthModdedPlants {
    private static final String SIMPLE_ORES = Mods.getModByNumericID(1).getID();
    private static final String MORE_ORES_IN_ONE = Mods.getModByNumericID(2).getID();
    private static final String JUST_ANOTHER_RUBY_MOD = Mods.getModByNumericID(3).getID();
    private static final String BLUE_POWER = Mods.getModByNumericID(4).getID();
    private static final String BASIC_NETHER_ORES = Mods.getModByNumericID(5).getID();
    private static final String MYSTICAL_AGRICULTURE = Mods.getModByNumericID(6).getID();
    private static final String MEKANISM = Mods.getModByNumericID(7).getID();
    private static final String BOTANIA = Mods.getModByNumericID(8).getID();
    private static final String THE_MIDNIGHT = Mods.getModByNumericID(9).getID();
    static final CrystallineSetProperties DIAMOND_PROPERTIES = new CrystallineSetProperties(false, 8.0f, 1, 1.5f, 25.0f);
    static final CrystallineSetProperties REDSTONE_PROPERTIES = new CrystallineSetProperties(false, 65.0f, 4, 1.0f, 75.0f);
    static final CrystallineSetProperties LAPIS_LAZULI_PROPERTIES = new CrystallineSetProperties(false, 45.0f, 3, 2.0f, 50.0f);
    static final CrystallineSetProperties COAL_PROPERTIES = new CrystallineSetProperties(false, 75.0f, 2, 0.5f, 50.0f);
    static final CrystallineSetProperties EMERALD_PROPERTIES = new CrystallineSetProperties(false, 7.0f, 1, 1.5f, 25.0f);
    private static final CrystallineSetProperties ONYX_PROPERTIES = new CrystallineSetProperties(false, 9.0f, 1, 7.0f, 5.0f);
    private static final CrystallineSetProperties RUBY_PROPERTIES = new CrystallineSetProperties(false, 14.0f, 1, 1.0f, 25.0f);
    private static final CrystallineSetProperties SAPPHIRE_PROPERTIES = new CrystallineSetProperties(false, 14.0f, 1, 1.0f, 25.0f);
    private static final CrystallineSetProperties TOPAZ_PROPERTIES = new CrystallineSetProperties(false, 14.0f, 1, 1.0f, 25.0f);
    private static final CrystallineSetProperties AMETHYST_PROPERTIES = new CrystallineSetProperties(false, 14.0f, 1, 1.0f, 25.0f);
    private static final CrystallineSetProperties OPAL_PROPERTIES = new CrystallineSetProperties(false, 14.0f, 1, 1.0f, 25.0f);
    private static final CrystallineSetProperties MALACHITE_PROPERTIES = new CrystallineSetProperties(false, 14.0f, 1, 1.0f, 25.0f);
    private static final CrystallineSetProperties TESLATITE_PROPERTIES = new CrystallineSetProperties(false, 13.0f, 1, 1.0f, 25.0f);
    private static final CrystallineSetProperties PROSPERITY_PROPERTIES = new CrystallineSetProperties(false, 18.0f, 2, 1.0f, 10.0f);
    private static final CrystallineSetProperties INFERIUM_PROPERTIES = new CrystallineSetProperties(false, 20.0f, 2, 1.5f, 10.0f);
    private static final CrystallineSetProperties SOULIUM_PROPERTIES = new CrystallineSetProperties(false, 18.0f, 2, 1.0f, 10.0f);
    private static final CrystallineSetProperties BOTANIA_PETAL_PROPERTIES = new CrystallineSetProperties(false, 25.0f, 2, 10.0f, 20.0f);
    private static final CrystallineSetProperties MIDNIGHT_CRYSTALLINE = new CrystallineSetProperties(false, 35.0f, 1, 3.0f, 6.0f);
    private static final MetallicSetProperties MIDNIGHT_METALLIC = new MetallicSetProperties(false, 35.0f, 3.0f, 6.0f);
    static final MetallicSetProperties IRON_PROPERTIES = new MetallicSetProperties(false, 40.0f, 6.0f, 6.0f);
    static final MetallicSetProperties GOLD_PROPERTIES = new MetallicSetProperties(false, 25.0f, 5.0f, 5.0f);
    private static final MetallicSetProperties COPPER_PROPERTIES = new MetallicSetProperties(false, 35.0f, 7.0f, 7.0f);
    private static final MetallicSetProperties TIN_PROPERTIES = new MetallicSetProperties(false, 35.0f, 7.0f, 7.0f);
    private static final MetallicSetProperties ALUMINIUM_PROPERTIES = new MetallicSetProperties(false, 30.0f, 6.0f, 6.0f);
    private static final MetallicSetProperties LEAD_PROPERTIES = new MetallicSetProperties(false, 25.0f, 8.0f, 8.0f);
    private static final MetallicSetProperties NICKEL_PROPERTIES = new MetallicSetProperties(false, 25.0f, 8.0f, 8.0f);
    private static final MetallicSetProperties URANIUM_PROPERTIES = new MetallicSetProperties(false, 15.0f, 4.0f, 4.0f);
    private static final MetallicSetProperties SILVER_PROPERTIES = new MetallicSetProperties(false, 20.0f, 8.0f, 8.0f);
    private static final MetallicSetProperties ZINC_PROPERTIES = new MetallicSetProperties(false, 25.0f, 8.0f, 8.0f);
    private static final MetallicSetProperties TUNGSTEN_PROPERTIES = new MetallicSetProperties(false, 25.0f, 8.0f, 8.0f);
    private static final MetallicSetProperties MYTHRIL_PROPERTIES = new MetallicSetProperties(false, 25.0f, 5.0f, 5.0f);
    private static final MetallicSetProperties ADAMANTIUM_PROPERTIES = new MetallicSetProperties(false, 20.0f, 5.0f, 5.0f);
    static final MetallicSetProperties OSMIUM_PROPERTIES = new MetallicSetProperties(false, 30.0f, 6.0f, 6.0f);
    public static final PlantSet<?> SIMPLE_ORES_ONYX = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(SIMPLE_ORES, "onyx", ONYX_PROPERTIES, "onyx_ore"));
    public static final PlantSet<?> SIMPLE_ORES_COPPER = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(SIMPLE_ORES, "copper", COPPER_PROPERTIES, "copper_ore"));
    public static final PlantSet<?> SIMPLE_ORES_TIN = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(SIMPLE_ORES, "tin", TIN_PROPERTIES, "tin_ore"));
    public static final PlantSet<?> SIMPLE_ORES_MYTHRIL = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(SIMPLE_ORES, "mythril", MYTHRIL_PROPERTIES, "mythril_ore"));
    public static final PlantSet<?> SIMPLE_ORES_ADAMANTIUM = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(SIMPLE_ORES, "adamantium", ADAMANTIUM_PROPERTIES, "adamantium_ore"));
    public static final PlantSet<?> MORE_ORES_RUBY = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(MORE_ORES_IN_ONE, "ruby", RUBY_PROPERTIES, "ruby_ore"));
    public static final PlantSet<?> MORE_ORES_SAPPHIRE = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(MORE_ORES_IN_ONE, "sapphire", SAPPHIRE_PROPERTIES, "sapphire_ore"));
    public static final PlantSet<?> MORE_ORES_TOPAZ = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(MORE_ORES_IN_ONE, "topaz", TOPAZ_PROPERTIES, "topaz_ore"));
    public static final PlantSet<?> MORE_ORES_AMETHYST = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(MORE_ORES_IN_ONE, "amethyst", AMETHYST_PROPERTIES, "amethyst_ore"));
    public static final PlantSet<?> JUST_ANOTHER_RUBY_MOD_RUBY = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(JUST_ANOTHER_RUBY_MOD, "ruby", RUBY_PROPERTIES, "ruby_ore"));
    public static final PlantSet<?> JUST_ANOTHER_RUBY_MOD_OPAL = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(JUST_ANOTHER_RUBY_MOD, "opal", OPAL_PROPERTIES, "opal_ore"));
    public static final PlantSet<?> BLUE_POWER_AMETHYST = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(BLUE_POWER, "amethyst", AMETHYST_PROPERTIES, "amethyst_ore"));
    public static final PlantSet<?> BLUE_POWER_RUBY = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(BLUE_POWER, "ruby", RUBY_PROPERTIES, "ruby_ore"));
    public static final PlantSet<?> BLUE_POWER_SAPPHIRE = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(BLUE_POWER, "sapphire", SAPPHIRE_PROPERTIES, "sapphire_ore"));
    public static final PlantSet<?> BLUE_POWER_MALACHITE = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(BLUE_POWER, "malachite", MALACHITE_PROPERTIES, "malachite_ore"));
    public static final PlantSet<?> BLUE_POWER_TESLATITE = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(BLUE_POWER, "teslatite", TESLATITE_PROPERTIES, "teslatite_ore"));
    public static final PlantSet<?> BLUE_POWER_COPPER = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(BLUE_POWER, "copper", COPPER_PROPERTIES, "copper_ore"));
    public static final PlantSet<?> BLUE_POWER_SILVER = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(BLUE_POWER, "silver", SILVER_PROPERTIES, "silver_ore"));
    public static final PlantSet<?> BLUE_POWER_ZINC = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(BLUE_POWER, "zinc", ZINC_PROPERTIES, "zinc_ore"));
    public static final PlantSet<?> BLUE_POWER_TUNGSTEN = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(BLUE_POWER, "tungsten", TUNGSTEN_PROPERTIES, "tungsten_ore"));
    public static final PlantSet<?> BASIC_NETHER_ORES_IRON = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(BASIC_NETHER_ORES, "iron", IRON_PROPERTIES, "netheriron_ore"));
    public static final PlantSet<?> BASIC_NETHER_ORES_GOLD = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(BASIC_NETHER_ORES, "gold", GOLD_PROPERTIES, "nethergold_ore"));
    public static final PlantSet<?> BASIC_NETHER_ORES_COAL = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(BASIC_NETHER_ORES, "coal", COAL_PROPERTIES, "nethercoal_ore"));
    public static final PlantSet<?> BASIC_NETHER_ORES_LAPIS_LAZULI = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(BASIC_NETHER_ORES, "lapis_lazuli", LAPIS_LAZULI_PROPERTIES, "netherlapis_ore"));
    public static final PlantSet<?> BASIC_NETHER_ORES_REDSTONE = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(BASIC_NETHER_ORES, "redstone", REDSTONE_PROPERTIES, "netherredstone_ore"));
    public static final PlantSet<?> BASIC_NETHER_ORES_DIAMOND = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(BASIC_NETHER_ORES, "diamond", DIAMOND_PROPERTIES, "netherdiamond_ore"));
    public static final PlantSet<?> BASIC_NETHER_ORES_EMERALD = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(BASIC_NETHER_ORES, "emerald", EMERALD_PROPERTIES, "netheremerald_ore"));
    public static final PlantSet<?> BASIC_NETHER_ORES_URANIUM = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(BASIC_NETHER_ORES, "uranium", URANIUM_PROPERTIES, "netheruranium_ore"));
    public static final PlantSet<?> BASIC_NETHER_ORES_TIN = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(BASIC_NETHER_ORES, "tin", TIN_PROPERTIES, "nethertin_ore"));
    public static final PlantSet<?> BASIC_NETHER_ORES_SILVER = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(BASIC_NETHER_ORES, "silver", SILVER_PROPERTIES, "nethersilver_ore"));
    public static final PlantSet<?> BASIC_NETHER_ORES_NICKEL = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(BASIC_NETHER_ORES, "nickel", NICKEL_PROPERTIES, "nethernickel_ore"));
    public static final PlantSet<?> BASIC_NETHER_ORES_LEAD = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(BASIC_NETHER_ORES, "lead", LEAD_PROPERTIES, "netherlead_ore"));
    public static final PlantSet<?> BASIC_NETHER_ORES_COPPER = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(BASIC_NETHER_ORES, "copper", COPPER_PROPERTIES, "nethercopper_ore"));
    public static final PlantSet<?> BASIC_NETHER_ORES_ALUMINIUM = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(BASIC_NETHER_ORES, "aluminium", ALUMINIUM_PROPERTIES, "netheraluminum_ore"));
    public static final PlantSet<?> MEKANISM_OSMIUM = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(MEKANISM, "osmium", OSMIUM_PROPERTIES, "osmium_ore"));
    public static final PlantSet<?> MEKANISM_COPPER = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(MEKANISM, "copper", COPPER_PROPERTIES, "copper_ore"));
    public static final PlantSet<?> MEKANISM_TIN = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(MEKANISM, "tin", TIN_PROPERTIES, "tin_ore"));
    public static final PlantSet<?> MYSTICAL_AGRICULTURE_PROSPERITY = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(MYSTICAL_AGRICULTURE, "prosperity", PROSPERITY_PROPERTIES, "prosperity_ore"));
    public static final PlantSet<?> MYSTICAL_AGRICULTURE_INFERIUM = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(MYSTICAL_AGRICULTURE, "inferium", INFERIUM_PROPERTIES, "inferium_ore"));
    public static final PlantSet<?> MYSTICAL_AGRICULTURE_SOULIUM = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(MYSTICAL_AGRICULTURE, "soulium", SOULIUM_PROPERTIES, "soulium_ore"));
    public static final PlantSet<?> MIDNIGHT_TENEBRUM = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(THE_MIDNIGHT, "tenebrum", MIDNIGHT_METALLIC, "tenebrum_ore"));
    public static final PlantSet<?> MIDNIGHT_NAGRILITE = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedMetallicSet(THE_MIDNIGHT, "nagrilite", MIDNIGHT_METALLIC, "nagrilite_ore"));
    public static final PlantSet<?> MIDNIGHT_DARK_PEARL = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(THE_MIDNIGHT, "dark_pearl", MIDNIGHT_CRYSTALLINE, "dark_pearl_ore"));
    public static final PlantSet<?> MIDNIGHT_EBONITE = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(THE_MIDNIGHT, "ebonite", MIDNIGHT_CRYSTALLINE, "ebonite_ore"));
    public static final PlantSet<?> MIDNIGHT_ARCHAIC = ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(THE_MIDNIGHT, "archaic", MIDNIGHT_CRYSTALLINE, "archaic_ore"));
    public static final PlantSet<?> BOTANIA_WHITE_PETAL = ResynthModdedPlants.newBotaniaPetalSet("white");
    public static final PlantSet<?> BOTANIA_RED_PETAL = ResynthModdedPlants.newBotaniaPetalSet("red");
    public static final PlantSet<?> BOTANIA_ORANGE_PETAL = ResynthModdedPlants.newBotaniaPetalSet("orange");
    public static final PlantSet<?> BOTANIA_PINK_PETAL = ResynthModdedPlants.newBotaniaPetalSet("pink");
    public static final PlantSet<?> BOTANIA_YELLOW_PETAL = ResynthModdedPlants.newBotaniaPetalSet("yellow");
    public static final PlantSet<?> BOTANIA_LIME_PETAL = ResynthModdedPlants.newBotaniaPetalSet("lime");
    public static final PlantSet<?> BOTANIA_GREEN_PETAL = ResynthModdedPlants.newBotaniaPetalSet("green");
    public static final PlantSet<?> BOTANIA_LIGHT_BLUE_PETAL = ResynthModdedPlants.newBotaniaPetalSet("light_blue");
    public static final PlantSet<?> BOTANIA_CYAN_PETAL = ResynthModdedPlants.newBotaniaPetalSet("cyan");
    public static final PlantSet<?> BOTANIA_BLUE_PETAL = ResynthModdedPlants.newBotaniaPetalSet("blue");
    public static final PlantSet<?> BOTANIA_MAGENTA_PETAL = ResynthModdedPlants.newBotaniaPetalSet("magenta");
    public static final PlantSet<?> BOTANIA_PURPLE_PETAL = ResynthModdedPlants.newBotaniaPetalSet("purple");
    public static final PlantSet<?> BOTANIA_BROWN_PETAL = ResynthModdedPlants.newBotaniaPetalSet("brown");
    public static final PlantSet<?> BOTANIA_GRAY_PETAL = ResynthModdedPlants.newBotaniaPetalSet("gray");
    public static final PlantSet<?> BOTANIA_LIGHT_GRAY_PETAL = ResynthModdedPlants.newBotaniaPetalSet("light_gray");
    public static final PlantSet<?> BOTANIA_BLACK_PETAL = ResynthModdedPlants.newBotaniaPetalSet("black");

    private static PlantSet<?> newBotaniaPetalSet(String setIdentifier) {
        return ResynthModdedPlants.registerIfNotNull(PlantSetFactory.newModdedCrystallineSet(BOTANIA, setIdentifier + "_petal", BOTANIA_PETAL_PROPERTIES, setIdentifier + "_mystical_flower"));
    }

    private ResynthModdedPlants() {
    }

    public static void initSets() {
    }

    private static PlantSet<?> registerIfNotNull(PlantSet<?> set) {
        if (set == null) {
            return null;
        }
        return set.register();
    }

    public static class Mods {
        private static final Map<Integer, Mod> MOD_LIST = new HashMap<Integer, Mod>(){
            {
                this.putMod(1, new Mod("Simple Ores", "simpleores"));
                this.putMod(2, new Mod("More Ores in ONE", "moreoresinone"));
                this.putMod(3, new Mod("Just Another Ruby Mod", "ruby"));
                this.putMod(4, new Mod("Blue Power", "bluepower"));
                this.putMod(5, new Mod("Basic Nether Ores", "bno"));
                this.putMod(6, new Mod("Mystical Agriculture", "mysticalagriculture"));
                this.putMod(7, new Mod("Mekanism", "mekanism"));
                this.putMod(8, new Mod("Botania", "botania"));
                this.putMod(9, new Mod("The Midnight", "midnight"));
            }

            public void putMod(Integer id, Mod mod) {
                this.put(id, mod);
                mod.numericID = id;
            }
        };

        public static Mod getModByNumericID(int id) {
            return MOD_LIST.getOrDefault(id, null);
        }

        public static Mod[] getAllMods() {
            ArrayList<Mod> mods = new ArrayList<Mod>(MOD_LIST.size() + 1);
            mods.addAll(MOD_LIST.values());
            return mods.toArray(new Mod[0]);
        }

        public static void iterateAllMods(Consumer<Mod> action) {
            MOD_LIST.values().iterator().forEachRemaining(action);
        }

        public static class Mod {
            private final String name;
            private final String id;
            private int numericID;

            private Mod(String name, String id) {
                this.name = name;
                this.id = id;
            }

            public String getName() {
                return this.name;
            }

            public String getID() {
                return this.id;
            }

            public int getNumericID() {
                return this.numericID;
            }
        }
    }
}

