/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.analytics;

import com.ki11erwolf.resynth.ResynthMod;
import com.ki11erwolf.resynth.analytics.Event;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.GeneralConfig;
import com.ki11erwolf.resynth.util.SSLHelper;
import dmurph.tracking.AnalyticsConfigData;
import dmurph.tracking.AnalyticsRequestData;
import dmurph.tracking.JGoogleAnalyticsTracker;
import org.apache.logging.log4j.Logger;

public final class ResynthAnalytics {
    private static final Logger LOG = ResynthMod.getNewLogger();
    private static final boolean ENABLED = ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class).isAnalyticsEnabled();
    private static final String CODE = "UA-127648959-1";
    private static final String RESYNTH_DOMAIN = "https://resynth-minecraft-mod.github.io";
    private static final String IDENTIFIER_PAGE = "/jar";
    private static final String TITLE = "Resynth - Jar";
    private static final JGoogleAnalyticsTracker ANALYTICS;

    private ResynthAnalytics() {
    }

    public static void send(Event e) {
        if (!ENABLED || ANALYTICS == null) {
            LOG.info(String.format("Analytics disabled! Event (%s) prevented from sending.", e.toString()));
            SSLHelper.enableSSL();
            return;
        }
        SSLHelper.disableSSL();
        LOG.info("Sending analytics event: " + e.toString());
        ANALYTICS.makeCustomRequest(e.getEventData());
        SSLHelper.enableSSL();
    }

    static void setEventHost(AnalyticsRequestData eventData) {
        eventData.setHostName(RESYNTH_DOMAIN);
        eventData.setPageURL(IDENTIFIER_PAGE);
        eventData.setPageTitle(TITLE);
    }

    static {
        SSLHelper.disableSSL();
        if (ENABLED) {
            LOG.info("Analytics has been disabled!");
            ANALYTICS = new JGoogleAnalyticsTracker(new AnalyticsConfigData(CODE), JGoogleAnalyticsTracker.GoogleAnalyticsVersion.V_4_7_2);
        } else {
            ANALYTICS = null;
        }
    }
}

