/*
 * Decompiled with CFR 0.152.
 */
package com.ki11erwolf.resynth.block;

import com.ki11erwolf.resynth.ResynthTabs;
import com.ki11erwolf.resynth.block.ResynthBlocks;
import com.ki11erwolf.resynth.config.ResynthConfig;
import com.ki11erwolf.resynth.config.categories.GeneralConfig;
import com.ki11erwolf.resynth.item.ResynthItemBlock;
import com.ki11erwolf.resynth.plant.set.PlantSetProperties;
import com.ki11erwolf.resynth.plant.set.PlantSetUtil;
import com.ki11erwolf.resynth.util.ExpandingTooltip;
import com.ki11erwolf.resynth.util.Tooltip;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import org.apache.commons.lang3.text.WordUtils;

public class ResynthBlock<T extends ResynthBlock<?>>
extends Block {
    private boolean isQueued = false;
    private final ResynthItemBlock itemBlock;

    public ResynthBlock(Block.Properties properties, String name) {
        this(properties, new Item.Properties().func_200916_a(ResynthTabs.TAB_RESYNTH), name);
    }

    public ResynthBlock(Block.Properties properties, Item.Properties itemProperties, String name) {
        super(properties);
        this.setRegistryName(name);
        this.itemBlock = new ResynthItemBlock(this, itemProperties);
        this.itemBlock.setRegistryName(name);
    }

    public ResynthItemBlock getItemBlock() {
        return this.itemBlock;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        new ExpandingTooltip().setCtrlForDescription(tooltips -> Tooltip.addBlankLine(tooltips).add(ResynthBlock.getDescriptiveTooltip(this))).write(tooltip).add(Tooltip.newBlankLine());
    }

    protected T queueRegistration() {
        if (this.isQueued) {
            throw new IllegalStateException(String.format("Block: %s already queued for registration.", ((Object)((Object)this)).getClass().getCanonicalName()));
        }
        ResynthBlocks.INSTANCE.queueForRegistration(this);
        this.itemBlock.queueRegistration();
        this.isQueued = true;
        return (T)((Object)this);
    }

    protected static void addPlantItemBlockTooltips(List<ITextComponent> tooltip, PlantSetProperties setProperties, String blockName) {
        new ExpandingTooltip().setShiftForStats(tooltips -> {
            PlantSetUtil.PlantSetTooltipUtil.setPropertiesTooltip((List<ITextComponent>)tooltips, setProperties);
            Tooltip.addBlankLine(tooltips);
        }).write(Tooltip.addBlankLine(tooltip));
        new ExpandingTooltip().setCtrlForDescription(tooltips -> Tooltip.addBlankLine(tooltips).add(ResynthBlock.getDescriptiveTooltip(blockName, new Object[0]))).write(tooltip);
        Tooltip.addBlankLine(tooltip);
    }

    protected static ITextComponent getDescriptiveTooltip(ResynthBlock<?> item) {
        return item == null || item.getRegistryName() == null ? Tooltip.toTextComponent(TextFormatting.RED + "Error") : ResynthBlock.getDescriptiveTooltip(item.getRegistryName().func_110623_a(), new Object[0]);
    }

    protected static ITextComponent getDescriptiveTooltip(String item, Object ... params) {
        if (item == null) {
            return Tooltip.toTextComponent(TextFormatting.RED + "Error");
        }
        return Tooltip.toTextComponent(WordUtils.wrap((String)(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)("tooltip.block.resynth." + item), (Object[])params)), (int)ResynthConfig.GENERAL_CONFIG.getCategory(GeneralConfig.class).getTooltipCharacterLimit(), (String)"\n", (boolean)true));
    }
}

